% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lock5withR-package.R
\docType{data}
\name{LightatNight}
\alias{LightatNight}
\title{Light at Night for Mice}
\format{A dataset with 27 observations on the following 9 variables.
\itemize{
	\item{\code{Light}} {\code{DM}=dim light at night, 
			\code{LD}=dark at night, or \code{LL}=bright light at night}
	\item{\code{BMGain}} {Body mass gain (in grams over a four week period)}
	\item{\code{Corticosterone}} {Blood corticosterene level (a measure of stress)}
	\item{\code{DayPct}} {Percent of calories eaten during the day}
	\item{\code{Consumption}} {Daily food consumption (grams)}
	\item{\code{GlucoseInt}} {Glucose intolerant? \code{No} or \code{Yes}}
	\item{\code{GTT15}} {Glucose level in the blood 15 minutes
			after a glucose injection}
	\item{\code{GTT120}} {Glucose level in the blood 120 minutes after a 
			glucose injection}
	\item{\code{Activity}} {A measure of physical activity level}
}}
\source{
Fonken, L., et. al., "Light at night increases body mass by shifting
time of food intake," Proceedings of the National Academy of Sciences,
October 26, 2010; 107(43): 18664-18669.
}
\description{
Data from an experiment with mice having different nighttime light
conditions
}
\details{
In this study, 27 mice were randomly split into three groups. One group was
on a normal light/dark cycle (LD), one group had bright light on all the
time (LL), and one group had light during the day and dim light at night
(DM). The dim light was equivalent to having a television set on in a room.
The mice in darkness ate most of their food during their active (nighttime)
period, matching the behavior of mice in the wild. The mice in both dim
light and bright light, however, consumed more than half of their food
during the well-lit rest period, when most mice are sleeping.
}
\keyword{datasets}

