% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qca.R
\name{QCAtt2LOtt}
\alias{QCAtt2LOtt}
\title{Create logicopt tt from QCA tt}
\usage{
QCAtt2LOtt(qcatt)
}
\arguments{
\item{qcatt}{An R data frame table generated by QCAGUI or QCApro truthTable().}
}
\value{
truth table for logicopt()
}
\description{
This function takes a truth table produced by the package 
QCAGUI (or QCApro) function truthTable() and creates an logicopt() format 
truth table.
}
\examples{
\dontrun{
inpath <- system.file("extdata/raw_qca/partybans.csv", package="LogicOpt")
partybans <- read.csv(inpath,row.names=1,na="")
library(QCAGUI)  
q.partybans.1 <- truthTable(partybans, conditions = c("C","F","T","R","V"), outcome = "PB{1}")
l.partybans.1 <- QCAtt2LOtt(q.partybans.1)
}
}

