% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FABS-estimation.R
\name{Lorenz.FABS}
\alias{Lorenz.FABS}
\title{Solves the Penalized Lorenz Regression with Lasso penalty}
\usage{
Lorenz.FABS(
  YX_mat,
  weights = NULL,
  h,
  w.adaptive = NULL,
  eps,
  iter = 10^4,
  lambda = "Shi",
  lambda.min = 1e-07,
  gamma = 0.05
)
}
\arguments{
\item{YX_mat}{a matrix with the first column corresponding to the response vector, the remaining ones being the explanatory variables.}

\item{weights}{vector of sample weights. By default, each observation is given the same weight.}

\item{h}{bandwidth of the kernel, determining the smoothness of the approximation of the indicator function.}

\item{w.adaptive}{vector of size equal to the number of covariates where each entry indicates the weight in the adaptive Lasso. By default, each covariate is given the same weight (Lasso).}

\item{eps}{step size in the FABS algorithm.}

\item{iter}{maximum number of iterations. Default value is 10^4.}

\item{lambda}{this parameter relates to the regularization parameter. Several options are available.
\describe{
    \item{\code{grid}}{If lambda="grid", lambda is defined on a grid, equidistant in the logarithmic scale.}
    \item{\code{Shi}}{If lambda="Shi", lambda, is defined within the algorithm, as in Shi et al (2018).}
    \item{\code{supplied}}{If the user wants to supply the lambda vector himself}
}}

\item{lambda.min}{lower bound of the penalty parameter. Only used if lambda="Shi".}

\item{gamma}{value of the Lagrange multiplier in the loss function}
}
\value{
A list with several components:
\describe{
   \item{\code{iter}}{number of iterations attained by the algorithm.}
   \item{\code{direction}}{vector providing the direction (-1 = backward step, 1 = forward step) for each iteration.}
   \item{\code{lambda}}{value of the regularization parameter for each iteration.}
   \item{\code{h}}{value of the bandwidth.}
   \item{\code{theta}}{matrix where column i provides the estimated parameter vector for iteration i.}
   \item{\code{LR2}}{the Lorenz-\eqn{R^2} of the regression.}
   \item{\code{Gi.expl}}{the estimated explained Gini coefficient.}
}
}
\description{
\code{Lorenz.FABS} solves the penalized Lorenz regression with (adaptive) Lasso penalty on a grid of lambda values.
For each value of lambda, the function returns estimates for the vector of parameters and for the estimated explained Gini coefficient, as well as the Lorenz-\eqn{R^2} of the regression.
}
\details{
The regression is solved using the FABS algorithm developed by Shi et al (2018) and adapted to our case.
For a comprehensive explanation of the Penalized Lorenz Regression, see Jacquemain et al.
In order to ensure identifiability, theta is forced to have a L2-norm equal to one.
}
\section{References}{

Jacquemain, A., C. Heuchenne, and E. Pircalabelu (2022). A penalised bootstrap estimation procedure for the explained Gini coefficient.
Shi, X., Y. Huang, J. Huang, and S. Ma (2018). A Forward and Backward Stagewise Algorithm for Nonconvex Loss Function with Adaptive Lasso, \emph{Computational Statistics & Data Analysis 124}, 235-251.
}

\examples{
data(Data.Incomes)
YX_mat <- Data.Incomes[,-2]
Lorenz.FABS(YX_mat, h = nrow(Data.Incomes)^(-1/5.5), eps = 0.005)

}
\seealso{
\code{\link{Lorenz.Reg}}, \code{\link{PLR.wrap}}, \code{\link{Lorenz.SCADFABS}}
}
