% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LorenzRegression-package.R
\docType{package}
\name{LorenzRegression-package}
\alias{LorenzRegression}
\alias{LorenzRegression-package}
\title{LorenzRegression : A package to estimate and interpret Lorenz regressions}
\description{
The \code{LorenzRegression} package proposes a toolbox to estimate, produce inference on and interpret Lorenz regressions.
As argued in Heuchenne and Jacquemain (2020) and Jacquemain, A., C. Heuchenne, and E. Pircalabelu (2024), these regressions are used to determine the explanatory power of a set of covariates on the inequality of a response variable.
In a nutshell, each variable is given a weight in order to maximize the concentration index of the response with respect to a weighted sum of the covariates.
The obtained concentration index is called the explained Gini coefficient. If a single-index model with increasing link function is assumed, the explained Gini boils down to the Gini coefficient of the fitted part of the model.
This package rests on two main functions: \code{\link{Lorenz.Reg}} for the estimation process and \code{\link{Lorenz.boot}} for more complete inference (tests and confidence intervals).
}
\details{
We direct the user to Heuchenne and Jacquemain (2020) and Jacquemain, A., C. Heuchenne, and E. Pircalabelu (2024) for a rigorous exposition of the methodology and to the vignette \href{../doc/Vignette.html}{Learning Lorenz regressions with examples} for a motivational introduction of the \code{LorenzRegression} package.
}
\section{References}{

Heuchenne, C. and A. Jacquemain (2022). Inference for monotone single-index conditional means: A Lorenz regression approach. \emph{Computational Statistics & Data Analysis 167(C)}.
Jacquemain, A., C. Heuchenne, and E. Pircalabelu (2024). A penalised bootstrap estimation procedure for the explained Gini coefficient. \emph{Electronic Journal of Statistics 18(1) 247-300}.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/AlJacq/LorenzRegression}
  \item Report bugs at \url{https://github.com/AlJacq/LorenzRegression/issues}
}

}
\author{
\strong{Maintainer}: Alexandre Jacquemain \email{aljacquemain@gmail.com} (\href{https://orcid.org/0000-0001-9349-780X}{ORCID})

Other contributors:
\itemize{
  \item Xingjie Shi \email{xingjieshi@njue.edu.cn} (Author of an R implementation of the FABS algorithm available at https://github.com/shuanggema/Fabs, of which function Lorenz.FABS is derived) [contributor]
}

}
\keyword{internal}
