% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LR-summary.R
\name{summary.LR}
\alias{summary.LR}
\alias{summary.LR_boot}
\title{Summary for the Lorenz regression}
\usage{
\method{summary}{LR}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"LR"}. The object might also have S3 class \code{"LR_boot"} (which inherits from class \code{"PLR"}).}

\item{...}{Additional arguments.}
}
\value{
An object of class \code{"summary.LR"}, containing the following elements:
\describe{
   \item{\code{call}}{The matched call.}
   \item{\code{ineq}}{A matrix with one row and three columns providing information on explained inequality. The first column gives the explained Gini coefficient, the second column gives the Gini coefficient of the response. The third column gives the Lorenz-\eqn{R^2}.}
   \item{\code{coefficients}}{A matrix providing information on the estimated coefficients. The first column gives the estimates.
   If \code{object} inherits from \code{"LR_boot"}, bootstrap inference was performed and the matrix contains further information. The second column is the boostrap standard error. The third column is the z-value. Finally, the last column is the p-value.
   In this case, the class \code{"summary.LR_boot"} is added to the output.}
}
}
\description{
Provides a summary for an object of class \code{"LR"}.
}
\details{
The inference provided in the \code{coefficients} matrix is obtained by using the asymptotic normality and estimating the asymptotic variance via bootstrap.
}
\examples{
## For examples see example(Lorenz.Reg) and example(Lorenz.boot)

}
\seealso{
\code{\link{Lorenz.Reg}}, \code{\link{Lorenz.boot}}
}
