% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/calc_TLLxTxRatio.R
\name{calc_TLLxTxRatio}
\alias{calc_TLLxTxRatio}
\title{Calculate the Lx/Tx ratio for a given set of TL curves [beta version]}
\usage{
calc_TLLxTxRatio(Lx.data.signal, Lx.data.background, Tx.data.signal,
  Tx.data.background, signal.integral.min, signal.integral.max)
}
\arguments{
\item{Lx.data.signal}{\code{\linkS4class{RLum.Data.Curve}} or
\code{\link{data.frame}} (\bold{required}): TL data (x =
temperature, y = counts) (TL signal)}

\item{Lx.data.background}{\code{\linkS4class{RLum.Data.Curve}} or
\code{\link{data.frame}} (optional): TL data (x =
temperature, y = counts). If no data are provided no background subtraction
is performed.}

\item{Tx.data.signal}{\code{\linkS4class{RLum.Data.Curve}} or
\code{\link{data.frame}} (\bold{required}): TL data (x =
temperature, y = counts) (TL test signal)}

\item{Tx.data.background}{\code{\linkS4class{RLum.Data.Curve}} or
\code{\link{data.frame}} (optional): TL data (x =
temperature, y = counts). If no data are provided no background subtraction
is performed.}

\item{signal.integral.min}{\code{\link{integer}} (\bold{required}): channel number
for the lower signal integral bound (e.g. \code{signal.integral.min = 100})}

\item{signal.integral.max}{\code{\link{integer}} (\bold{required}): channel number
for the upper signal integral bound (e.g. \code{signal.integral.max = 200})}
}
\value{
Returns an S4 object of type \code{\linkS4class{RLum.Results}}.
Slot \code{data} contains a \link{list} with the following structure:\cr\cr
$ LxTx.table \cr .. $ LnLx \cr .. $ LnLx.BG \cr .. $ TnTx \cr .. $ TnTx.BG
\cr .. $ Net_LnLx \cr .. $ Net_LnLx.Error\cr
}
\description{
Calculate Lx/Tx ratio for a given set of TL curves.
}
\details{
-
}
\note{
\bold{This function has still BETA status!}
}
\section{Function version}{
 0.3.0 (2015-09-21 15:05:38)
}
\examples{
##load package example data
data(ExampleData.BINfileData, envir = environment())

##convert Risoe.BINfileData into a curve object
temp <- Risoe.BINfileData2RLum.Analysis(TL.SAR.Data, pos = 3)


Lx.data.signal <- get_RLum(temp, record.id=1)
Lx.data.background <- get_RLum(temp, record.id=2)
Tx.data.signal <- get_RLum(temp, record.id=3)
Tx.data.background <- get_RLum(temp, record.id=4)
signal.integral.min <- 210
signal.integral.max <- 230

output <- calc_TLLxTxRatio(Lx.data.signal,
                           Lx.data.background,
                           Tx.data.signal, Tx.data.background,
                           signal.integral.min, signal.integral.max)
get_RLum(output)
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
#' (France), Christoph Schmidt, University of Bayreuth (Germany)
\cr R Luminescence Package Team}
\references{
-
}
\seealso{
\code{\linkS4class{RLum.Results}}, \code{\link{analyse_SAR.TL}}
}
\keyword{datagen}

