% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_TIFF2R.R
\name{read_TIFF2R}
\alias{read_TIFF2R}
\title{Import TIFF Image Data into R}
\usage{
read_TIFF2R(file, verbose = TRUE, ...)
}
\arguments{
\item{file}{\link{character} (\strong{required}): file name}

\item{verbose}{\link{logical} (\emph{with default}): enable/disable output to the
terminal.}

\item{...}{not in use, for compatibility reasons only}
}
\value{
\linkS4class{RLum.Data.Image} object
}
\description{
Simple wrapper around \link[tiff:readTIFF]{tiff::readTIFF} to import TIFF images
and TIFF image stacks to be further processed within the package \code{'Luminescence'}
}
\section{Function version}{
 0.1.2
}

\examples{

\dontrun{
file <- file.choose()
image <- read_TIFF2R(file)

}

}
\seealso{
\link[tiff:readTIFF]{tiff::readTIFF}, \linkS4class{RLum.Data.Image}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. read_TIFF2R(): Import TIFF Image Data into R. Function version 0.1.2. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.0.0. https://r-lum.github.io/Luminescence/
}

\keyword{IO}
