/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import uk.ac.rhul.cs.cl1.NodeSet;
import uk.ac.rhul.cs.cl1.ValuedNodeSet;
import uk.ac.rhul.cs.cl1.ui.EmptyIcon;
import uk.ac.rhul.cs.cl1.ui.HeightLimitedJLabelRenderer;
import uk.ac.rhul.cs.cl1.ui.JMultiLineToolTip;
import uk.ac.rhul.cs.cl1.ui.NodeSetTableModel;
import uk.ac.rhul.cs.cl1.ui.PValueRenderer;
import uk.ac.rhul.cs.cl1.ui.ShowDetailedResultsAction;
import uk.ac.rhul.cs.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultViewerPanel
extends JPanel
implements TableModelListener {
    protected JLabel countLabel;
    protected JToolBar topToolBar;
    protected JTable table;
    protected JScrollPane scrollPane;

    public ResultViewerPanel() {
        this((List<ValuedNodeSet>)null);
    }

    public ResultViewerPanel(List<ValuedNodeSet> nodeSets) {
        this.setLayout(new BorderLayout());
        this.countLabel = new JLabel();
        this.countLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.table = new JTable(){

            public JToolTip createToolTip() {
                JMultiLineToolTip toolTip = new JMultiLineToolTip();
                toolTip.setFixedWidth(300);
                return toolTip;
            }

            public String getToolTipText(MouseEvent e) {
                NodeSetTableModel model = ResultViewerPanel.this.getTableModel();
                if (!(model instanceof NodeSetTableModel)) {
                    return "";
                }
                Point p = e.getPoint();
                int rowIndex = this.convertRowIndexToModel(this.rowAtPoint(p));
                return StringUtils.join((Object[])model.getMemberNames(rowIndex), ", ");
            }
        };
        this.table.setSelectionMode(2);
        this.table.setIntercellSpacing(new Dimension(0, 4));
        this.table.setAutoResizeMode(3);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.scrollPane, "Center");
        if (nodeSets != null) {
            this.setNodeSets(nodeSets);
        }
        this.topToolBar = new JToolBar();
        this.topToolBar.add(this.countLabel);
        this.topToolBar.add(Box.createHorizontalGlue());
        this.topToolBar.add(new JToggleButton(this.constructShowDetailedResultsAction()));
        this.topToolBar.setFloatable(false);
        this.topToolBar.setRollover(false);
        this.topToolBar.setBorderPainted(false);
        this.topToolBar.setOpaque(false);
        this.add((Component)this.topToolBar, "North");
    }

    public JButton addAction(Action action) {
        JButton button = this.topToolBar.add(action);
        button.setContentAreaFilled(false);
        button.setBorderPainted(false);
        button.setRolloverEnabled(true);
        return button;
    }

    protected Icon constructProgressIcon() {
        URL url = this.getClass().getResource("../resources/wait.jpg");
        return url != null ? new ImageIcon(url) : new EmptyIcon(32, 32);
    }

    protected ShowDetailedResultsAction constructShowDetailedResultsAction() {
        return new ShowDetailedResultsAction(this);
    }

    public List<NodeSet> getAllNodeSets() {
        NodeSetTableModel model = this.getTableModel();
        int numRows = model.getRowCount();
        ArrayList<NodeSet> result = new ArrayList<NodeSet>();
        for (int i = 0; i < numRows; ++i) {
            result.add(model.getNodeSetByIndex(this.table.convertRowIndexToModel(i)));
        }
        return result;
    }

    public NodeSet getSelectedNodeSet() {
        Integer selectedIndex = this.getSelectedNodeSetIndex();
        if (selectedIndex == null) {
            return null;
        }
        return this.getTableModel().getNodeSetByIndex(selectedIndex);
    }

    public List<NodeSet> getSelectedNodeSets() {
        NodeSetTableModel model = this.getTableModel();
        ArrayList<NodeSet> result = new ArrayList<NodeSet>();
        for (int idx : this.getSelectedNodeSetIndices()) {
            result.add(model.getNodeSetByIndex(idx));
        }
        return result;
    }

    public Integer getSelectedNodeSetIndex() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        return this.table.convertRowIndexToModel(selectedRow);
    }

    public int[] getSelectedNodeSetIndices() {
        int[] selectedRows = this.table.getSelectedRows();
        int[] selectedRowsInModel = new int[selectedRows.length];
        int i = 0;
        for (int idx : selectedRows) {
            selectedRowsInModel[i] = this.table.convertRowIndexToModel(idx);
            ++i;
        }
        return selectedRowsInModel;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public JTable getTable() {
        return this.table;
    }

    public NodeSetTableModel getTableModel() {
        return (NodeSetTableModel)this.table.getModel();
    }

    public void setNodeSets(List<ValuedNodeSet> set) {
        NodeSetTableModel model = new NodeSetTableModel(set);
        model.setProgressIcon(this.constructProgressIcon());
        model.addTableModelListener(this);
        this.table.setModel(model);
        this.tableChanged(null);
        this.scrollPane.setPreferredSize(this.table.getPreferredSize());
        try {
            TableRowSorter<NodeSetTableModel> rowSorter = new TableRowSorter<NodeSetTableModel>(model);
            rowSorter.setSortable(0, false);
            if (!model.isInDetailedMode()) {
                ArrayList<RowSorter.SortKey> list = new ArrayList<RowSorter.SortKey>();
                list.add(new RowSorter.SortKey(1, SortOrder.DESCENDING));
                rowSorter.setSortKeys(list);
            }
            this.table.setRowSorter(rowSorter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setupTableColumnModel() {
        NodeSetTableModel model = (NodeSetTableModel)this.table.getModel();
        TableColumnModel colModel = this.table.getColumnModel();
        colModel.getColumn(0).setPreferredWidth(60);
        colModel.getColumn(0).setMaxWidth(60);
        if (!model.isInDetailedMode()) {
            colModel.getColumn(1).setPreferredWidth(120);
            colModel.getColumn(1).setCellRenderer(new HeightLimitedJLabelRenderer(50));
        } else {
            this.table.setRowHeight(60);
            colModel.getColumn(6).setCellRenderer(new PValueRenderer());
        }
    }

    public void setSelectedNodeSetIndices(int[] indices) {
        ListSelectionModel model = this.table.getSelectionModel();
        model.setValueIsAdjusting(true);
        model.clearSelection();
        for (int i : indices) {
            model.addSelectionInterval(i, i);
        }
        model.setValueIsAdjusting(false);
    }

    public void setSelectedNodeSetIndices(List<Integer> indices) {
        ListSelectionModel model = this.table.getSelectionModel();
        model.setValueIsAdjusting(true);
        model.clearSelection();
        for (int i : indices) {
            int j = this.table.convertRowIndexToView(i);
            model.addSelectionInterval(j, j);
        }
        model.setValueIsAdjusting(false);
    }

    private void updateCounterLabel() {
        int n = this.getTableModel().getRowCount();
        if (n == 0) {
            this.countLabel.setText("No clusters");
        } else if (n == 1) {
            this.countLabel.setText("1 cluster");
        } else {
            this.countLabel.setText(n + " clusters");
        }
    }

    @Override
    public void tableChanged(TableModelEvent event) {
        this.setupTableColumnModel();
        this.updateCounterLabel();
    }
}

