% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_PPIscore.R
\name{calculate_PPIscore}
\alias{calculate_PPIscore}
\title{Calculate Pairwise Protein Profile Similarity using Different
Metrics}
\usage{
calculate_PPIscore(
  x,
  pcc = TRUE,
  PCCN = TRUE,
  pcc_p = TRUE,
  spearman = TRUE,
  kendall = TRUE,
  bicor = TRUE,
  weighted_rank = TRUE,
  cosine = TRUE,
  jaccard = TRUE,
  dice = TRUE,
  apex = TRUE,
  minfo = TRUE,
  bayesian = TRUE,
  wcc = TRUE,
  euclidean = TRUE,
  manhattan = TRUE,
  canberra = TRUE,
  avg.distance = TRUE,
  rept = 10,
  corr_removal = FALSE,
  corr_cutoff = 0.5
)
}
\arguments{
\item{x}{A co-elution data matrix with proteins in rows and
fractions in columns.}

\item{pcc}{If TRUE, computes pairwise protein profile similarity
using Pearson correlation metric.}

\item{PCCN}{If TRUE, computes pairwise protein profile similarity using
Pearson correlation plus noise.This function is adapted from the
PCCN function in the SMED package.}

\item{pcc_p}{If TRUE, computes P-value of the Pearson correlation.}

\item{spearman}{if TRUE, computes pairwise protein profile similarity using
spearman correlation.}

\item{kendall}{if TRUE, computes pairwise protein profile similarity using
kendall correlation.}

\item{bicor}{if TRUE, computes pairwise protein profile similarity using
biweight midcorrealtion (bicor) correlation.}

\item{weighted_rank}{if TRUE, computes pairwise protein profile similarity
using weighted rank measure.}

\item{cosine}{If TRUE, computes pairwise protein profile similarity
using cosine metric.}

\item{jaccard}{If TRUE, computes pairwise protein profile similarity
using jaccard metric.}

\item{dice}{if TRUE, computes pairwise protein profile similarity
using dice measure.}

\item{apex}{If TRUE, computes pairwise protein profile similarity
using apex.}

\item{minfo}{If TRUE, computes pairwise protein profile similarity
using mutual information.}

\item{bayesian}{If TRUE, computes pairwise protein profile similarity using
Bayes correlation based on zero-count distribution.}

\item{wcc}{If TRUE, computes pairwise protein profile similarity
using weighted cross correlation.}

\item{euclidean}{if TRUE, computes pairwise protein profile similarity
using euclidean measure.}

\item{manhattan}{if TRUE, computes pairwise protein profile similarity
using manhattan measure.}

\item{canberra}{if TRUE, computes pairwise protein profile similarity
using canberra measure.}

\item{avg.distance}{if TRUE, computes pairwise protein profile similarity
using avg.distance measure.}

\item{rept}{Poisson iterations, defaults to 10.}

\item{corr_removal}{If TRUE, removes protein pairs with
correlation scores < the user defined threshold ; defaults to FALSE.}

\item{corr_cutoff}{user defined threshold for correlation similarity
scores. Defaults to 0.5.}
}
\value{
A data frame containing the calculated features for all possible
protein pairs.
}
\description{
This function first removes proteins pairs for which two
proteins never occurred in the same fractions, then computes
pairwise protein similarity using up to 18 metrics (by default all the 18
measures are activated). This function also
provides users with an option to choose an appropriate co-fractionation
correlation score cut-off using the `corr_cutoff` argument,
if argument `corr_removal` is set to TRUE.
}
\details{
calculate_PPIscore
}
\examples{
M1<-matrix(rnorm(36),nrow=6)
M1 <- abs(M1)
rownames(M1) <- c("A","B","C","D","E","F")
scored_Data <- calculate_PPIscore(M1)
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
