# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Fit the ADMM part of  model for a given lambda vale
#' @param X  n by p matrix of predictors
#' @param Z n by nz matrix of modifying variables. The elements of z
#' may represent quantitative or categorical variables, or a mixture of the two.
#' Categorical variables should be coded by 0-1 dummy variables: for a k-level
#' variable, one can use either k or k-1  dummy variables.
#' @param beta0 a vector of length ncol(y) of estimated beta_0 coefficients
#' @param theta0 matrix of the initial theta_0 coefficients  ncol(Z) by ncol(y)
#' @param beta  a matrix of the initial beta coefficients    ncol(X) by ncol(y)
#' @param beta_hat  a matrix of the initial beta and theta coefficients    (ncol(X)+ncol(X) by ncol(Z)) by ncol(y)
#' @param theta an array of initial theta coefficients    ncol(X) by ncol(Z) by ncol(y)
#' @param rho1 the Lagrange variable for the ADMM which is usually included as rho in the MADMMplasso call.
#' @param max_it maximum number of iterations in loop for one lambda during the ADMM optimization. This is usually included  in the MADMMplasso call
#' @param W_hat N by (p+(p by nz)) of the main and interaction predictors. This generated internally  when MADMMplasso is called or by using the function generate_my_w.
#' @param XtY a matrix formed by multiplying the transpose of X by y.
#' @param y  N by D matrix  of responses. The X and Z variables are centered in the function. We recommend that X and Z also be standardized before the call
#' @param N nrow(X)
#' @param e_abs absolute error for the ADMM. This is included int the call of MADMMplasso.
#' @param e_rel relative error for the ADMM. This is included int the call of MADMMplasso.
#' @param alpha mixing parameter, usually obtained from the MADMMplasso call. When the goal is to include more interactions, alpha should be very small and vice versa.
#' @param lambda a vector  lambda_3 values for the ADMM call with length ncol(y). This is usually calculated in the MADMMplasso call.   In our current setting, we use the same the lambda_3 value for all responses.
#' @param alph an overrelaxation parameter in \[1, 1.8\], usually obtained from the MADMMplasso call.
#' @param svd_w_tu the transpose of the U matrix from the SVD of W_hat
#' @param svd_w_tv the transpose of the V matrix from the SVD of W_hat
#' @param svd_w_d the D matrix from the SVD of W_hat
#' @param C the trained tree
#' @param CW weights for the trained tree
#' The easy way to obtain this is by using the function (tree_parms) which gives a default clustering.
#' However, user decide on a specific structure and then input a tree that follows such structure.
#' @param my_print Should information form each ADMM iteration be printed along the way? Default TRUE. This prints  the dual and primal residuals
#' @param gg penalty terms for the tree structure for lambda_1 and  lambda_2 for the ADMM call.
#' @return  predicted values for the ADMM part
#' @description This function fits a multi-response pliable lasso model over a path of regularization values.
#' @export
admm_MADMMplasso_cpp <- function(beta0, theta0, beta, beta_hat, theta, rho1, X, Z, max_it, W_hat, XtY, y, N, e_abs, e_rel, alpha, lambda, alph, svd_w_tu, svd_w_tv, svd_w_d, C, CW, gg, my_print = TRUE) {
    .Call(`_MADMMplasso_admm_MADMMplasso_cpp`, beta0, theta0, beta, beta_hat, theta, rho1, X, Z, max_it, W_hat, XtY, y, N, e_abs, e_rel, alpha, lambda, alph, svd_w_tu, svd_w_tv, svd_w_d, C, CW, gg, my_print)
}

count_nonzero_a_cpp <- function(x) {
    .Call(`_MADMMplasso_count_nonzero_a_cpp`, x)
}

count_nonzero_a_sp_mat <- function(x) {
    .Call(`_MADMMplasso_count_nonzero_a_sp_mat`, x)
}

count_nonzero_a_cube <- function(x) {
    .Call(`_MADMMplasso_count_nonzero_a_cube`, x)
}

count_nonzero_a_mat <- function(x) {
    .Call(`_MADMMplasso_count_nonzero_a_mat`, x)
}

hh_nlambda_loop_cpp <- function(lam, nlambda, beta0, theta0, beta, beta_hat, theta, rho1, X, Z, max_it, my_W_hat, XtY, y, N, e_abs, e_rel, alpha, alph, my_print, gg, tol, parallel, pal, BETA0, THETA0, BETA, BETA_hat, Y_HAT, D, C, CW, svd_w_tu, svd_w_tv, svd_w_d, my_values) {
    .Call(`_MADMMplasso_hh_nlambda_loop_cpp`, lam, nlambda, beta0, theta0, beta, beta_hat, theta, rho1, X, Z, max_it, my_W_hat, XtY, y, N, e_abs, e_rel, alpha, alph, my_print, gg, tol, parallel, pal, BETA0, THETA0, BETA, BETA_hat, Y_HAT, D, C, CW, svd_w_tu, svd_w_tv, svd_w_d, my_values)
}

model_intercept <- function(beta, X) {
    .Call(`_MADMMplasso_model_intercept`, beta, X)
}

model_p <- function(beta0, theta0, beta, X, Z) {
    .Call(`_MADMMplasso_model_p`, beta0, theta0, beta, X, Z)
}

modulo <- function(x, n) {
    .Call(`_MADMMplasso_modulo`, x, n)
}

multiples_of <- function(x, divisor, subset_out = FALSE) {
    .Call(`_MADMMplasso_multiples_of`, x, divisor, subset_out)
}

lm_arma <- function(R, Z) {
    .Call(`_MADMMplasso_lm_arma`, R, Z)
}

reg <- function(r, Z) {
    .Call(`_MADMMplasso_reg`, r, Z)
}

scale_cpp <- function(x, scale) {
    .Call(`_MADMMplasso_scale_cpp`, x, scale)
}

sqrt_sum_squared_rows <- function(x) {
    .Call(`_MADMMplasso_sqrt_sum_squared_rows`, x)
}

