% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Visualizing_MAGMA_functions.R
\name{Plot_MAGMA}
\alias{Plot_MAGMA}
\title{Plot_MAGMA}
\usage{
Plot_MAGMA(
  Balance,
  criterion = c("Pillai", "d_ratio", "mean_g", "Adj_d_ratio")
)
}
\arguments{
\item{Balance}{A result of Balance_MAGMA. Compare the function
\code{\link{Balance_MAGMA}}.}

\item{criterion}{A character vector specifying for which balance criteria
a plot should be created. Default is all criteria.}
}
\value{
R Plots showing the balance trend over sample size.
}
\description{
Plots for balance with respect to sample size.
}
\details{
This function creates R-Plots using ggplot2 to show the balance trend over
sample size.
}
\examples{

# This function bases on a MAGMA function as well as Balance_MAGMA
# To run examples, copy them into your console or script
# Defining the names of the metric and binary covariates
covariates_vector <- c("GPA_school", "IQ_score", "Motivation", "parents_academic", "gender")

#  Estimating balance of a two-group matching using the data set
# 'MAGMA_sim_data'.
# Matching variable 'gifted_support' (received giftedness support yes or no)
Balance_gifted <- Balance_MAGMA(Data = MAGMA_sim_data[MAGMA_sim_data$step_gifted < 150, ],
                                group = "gifted_support",
                                covariates = covariates_vector,
                                step = "step_gifted") 

Plot_MAGMA(Balance = Balance_gifted,
           criterion = "Adj_d_ratio") #Using default to plot all criteria

\donttest{
# 2x2 matching using the data set 'MAGMA_sim_data'
# Matching variables are 'gifted_support' (received giftedness support yes
# or no) and 'enrichment' (participated in enrichment or not)
# 'MAGMA_sim_data_gift_enrich' contains the result of the matching
# 2x2 matching is equivalent to four-group matching
MAGMA_sim_data_gift_enrich <- MAGMA(Data = MAGMA_sim_data,
                                   group = c("gifted_support", "enrichment"),
                                   dist = "ps_2x2",
                                   cores = 2)


# Estimating balance. Covariates same as above
Balance_2x2 <- Balance_MAGMA(Data = MAGMA_sim_data_gift_enrich,
                             group = c("gifted_support", "enrichment"),
                             covariates = covariates_vector,
                             step = "step") #step created during matching

Plot_MAGMA(Balance = Balance_2x2,
           criterion = c("d_ration", "Adj_d_ratio"))
}

}
\author{
Julian Urban
}
