% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_afterOrtho.R
\name{format_afterOrtho}
\alias{format_afterOrtho}
\title{Format file from output of OrthoMCL algorithm before use in analyzeOrthoMCL}
\usage{
format_afterOrtho(file, format = "ortho")
}
\arguments{
\item{file}{Path to the orthoMCL output file}

\item{format}{Specification of the method by which file was obtained: defaults to 'ortho' for output from orthomcl.org. Other option is 'groups' for output from local run of OrthoMCL software.}
}
\value{
a list of matrices; (1) a presence/absence matrix of taxa per OG, (2) a list of the specific protein ids within each OG
}
\description{
After running OrthoMCL and/or submitting to www.orthomcl.org, formats the output file to be used in analyzeOrthoMCL
}
\examples{
file <- system.file('extdata', 'orthologGroups.txt', package='MAGNAMWAR')
after_ortho_format <- format_afterOrtho(file)

file_grps <- system.file('extdata', 'groups_example_r.txt', package='MAGNAMWAR')
after_ortho_format_grps <- format_afterOrtho(file_grps, format = 'groups')

}
