% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnalyzeOrthoMCL.R
\name{AnalyzeOrthoMCL}
\alias{AnalyzeOrthoMCL}
\title{Main OrthoMCL Analysis}
\usage{
AnalyzeOrthoMCL(mcl_data, pheno_data, model, species_name, resp = NULL,
  fix2 = NULL, rndm1 = NULL, rndm2 = NULL, multi = 1, time = NULL,
  event = NULL, time2 = NULL, startnum = 1, stopnum = "end",
  output_dir = NULL, sig_digits = NULL, princ_coord = 0)
}
\arguments{
\item{mcl_data}{output of FormatAfterOrtho; a list of matrices; (1) a presence/absence matrix of taxa per OG, (2) a list of the specific protein ids within each OG}

\item{pheno_data}{a data frame of phenotypic data with specific column names used to specify response variable as well as other fixed and random effects}

\item{model}{linear model with gene presence as fixed effect (lm), linear mixed mffect models with gene presence as fixed effect and additional variables specified as: one random effect (lmeR1); two independent random effects (lmeR2ind); two random effects with rndm2 nested in rndm1 (lmeR2nest); or two independent random effects with one additional fixed effect (lmeF2), Wilcox Test with gene presence as fixed effect (wx), Survival Tests with support for multi core design: with two random effects (survmulti), and with two times as well as an additional fixed variable (survmulticensor)}

\item{species_name}{Column name in pheno_data containing 4-letter species designations}

\item{resp}{Column name in pheno_data containing response variable}

\item{fix2}{Column name in pheno_data containing second fixed effect}

\item{rndm1}{Column name in pheno_data containing first random variable}

\item{rndm2}{Column name in pheno_data containing second random variable}

\item{multi}{(can only be used with survival tests) Number of cores}

\item{time}{(can only be used with survival tests) Column name in pheno_data containing first time}

\item{event}{(can only be used with survival tests) Column name in pheno_data containing event}

\item{time2}{(can only be used with survival tests) Column name in pheno_data containing second time}

\item{startnum}{number of test to start on}

\item{stopnum}{number of test to stop on}

\item{output_dir}{(if using survival tests) directory where small output files will be placed before using SurvAppendMatrix. Must specify a directory if choosing to output small files, else only written as a matrix}

\item{sig_digits}{amount of digits to display for p-values and means of data; default to NULL (no rounding)}

\item{princ_coord}{the number of principle coordinates to be included in model as fixed effects (1, 2, or 3), if a decimal is specified, as many principal coordinates as are needed to account for that percentage of the variance will be included in the analysis}
}
\value{
A matrix with the following columns: OG, p-values, Bonferroni corrected p-values, mean phenotype of OG-containing taxa, mean pheotype of OG-lacking taxa, taxa included in OG, taxa not included in OG
}
\description{
Main function for analyzing the statistical association of OG (orthologous group) presence with phenotype data
}
