\name{writeIntensity}
\alias{writeIntensity}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Write intensity matrix in different formats
}
\description{
This function writes an intensity matrix as generated by \code{\link{intensityMatrix}} into a file in the R, csv, NEXUS or FASTA formats. For NEXUS format it allows to specify weights for peaks.
}
\usage{
writeIntensity(x, filename = "intMatrix", format = c("R", "csv", "NEXUS", "FASTA"),
               binary = FALSE, labels = NULL, weights=NULL, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
Intensity matrix as obtained from \code{\link{intensityMatrix}}.
}
  \item{filename}{
A character string specifying a name for the destination file (filename extension not required).
}
  \item{format}{
One of R (default \code{.RData} file), text (comma-separated \code{.csv} file), NEXUS (\code{.nex} file) or FASTA (\code{.fas} file).
}
  \item{binary}{
Logical value. If \code{TRUE}, a binary version (1: peak presence, 0: peak absence) of \code{x} is saved (default \code{FALSE}).
}
  \item{labels}{
Optional vector of ID labels for the samples.
}
  \item{weights}{
Optional numeric vector of peak weights (NEXUS format).
}
  \item{\dots}{
Additional arguments.
}
}
\details{
This is a wrapper function to simplify the writing of an intensity matrix in different formats while adding some extra features. It includes the common NEXUS and FASTA formats as an extension of functions in the \code{ape} package to handle peak intensity data. It also allows for taxa/sample pre-computed peak weights to be included in the NEXUS file. It checks whether the names meet NEXUS name conventions and gives them adequate format if not. A binary intensity matrix is always internally generated (\code{binary = TRUE}) when either the NEXUS or FASTA format is chosen. If any, \code{NA} values in \code{x} are assumed to denote zero intensity/peak absence and are then converted into zeros.
}
\value{No return value, file in selected format created on destination folder.}
\examples{
# Load example data

data(spectra) # list of MassSpectra class objects

# Some pre-processing

spectra <- screenSpectra(spectra)$fspectra
spectra <- transformIntensity(spectra, method = "sqrt")
spectra <- wavSmoothing(spectra)
spectra <- removeBaseline(spectra)
peaks <- detectPeaks(spectra)
peaks <- alignPeaks(peaks, minFreq = 0.8)

# Intensity matrix

int <- intensityMatrix(peaks)

# Save as R file (saved to a temporary location as an example)
\donttest{
writeIntensity(int, file = file.path(tempdir(), "int"))
}
# Save as binary NEXUS file (saved to a temporary location as an example)
\donttest{
writeIntensity(int, file = file.path(tempdir(),"int.binary"),
               format = "NEXUS", interleaved = FALSE)
}
}
