% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simultaneous.R
\name{ordinal.mams}
\alias{ordinal.mams}
\title{Function to design multi-arm multi-stage studies with ordinal or binary
endpoints}
\usage{
ordinal.mams(
  prob = c(0.35, 0.4, 0.25),
  or = 2,
  or0 = 1.2,
  K = 4,
  J = 2,
  alpha = 0.05,
  power = 0.9,
  r = 1:2,
  r0 = 1:2,
  ushape = "obf",
  lshape = "fixed",
  ufix = NULL,
  lfix = 0,
  nstart = 1,
  nstop = NULL,
  sample.size = TRUE,
  Q = 20,
  parallel = TRUE,
  print = TRUE
)
}
\arguments{
\item{prob}{Vector of expected probabilities of falling into each category
under control conditions. The elements must sum up to one
(default=c(0.35, 0.4, 0.25)).}

\item{or}{Interesting treatment effect on the scale of odds ratios
(default=2).}

\item{or0}{Uninteresting treatment effect on the scale of odds ratios
(default=1.2).}

\item{K}{Number of experimental treatments (default=4).}

\item{J}{Number of stages (default=2).}

\item{alpha}{One-sided familywise error rate (default=0.05).}

\item{power}{Desired power (default=0.9).}

\item{r}{Vector of allocation ratios (default=1:2).}

\item{r0}{Vector ratio on control (default=1:2).}

\item{ushape}{Shape of upper boundary. Either a function specifying the
shape or one of "pocock", "obf" (the default), "triangular" and "fixed".}

\item{lshape}{Shape of lower boundary. Either a function specifying the
shape or one of "pocock", "obf", "triangular" and "fixed" (the default).}

\item{ufix}{Fixed upper boundary (default=NULL). Only used if shape="fixed".}

\item{lfix}{Fixed lower boundary (default=0). Only used if shape="fixed".}

\item{nstart}{Starting point for finding the sample size (default=1).}

\item{nstop}{Stopping point for finding the sample size (default=NULL).}

\item{sample.size}{Logical if sample size should be found as well
(default=TRUE).}

\item{Q}{Number of quadrature points per dimension in the outer integral
(default=20).}

\item{parallel}{if TRUE (default), allows parallelisation of the computation
via a user-defined strategy specified by means of the function
future::plan(). If not set differently, the default strategy is sequential,
which corresponds to a computation without parallelisation.}

\item{print}{if TRUE (default), indicate at which stage the computation is.}
}
\value{
An object of the class MAMS containing the following components: \cr
\item{prob}{Vector of expected probabilities of falling into each category
under control conditions. The elements must sum up to one
(default=\code{c(0.35, 0.4, 0.25)}).}
\item{or}{Interesting treatment effect on the scale of odds ratios
(default=\code{2}).}
\item{or0}{Uninteresting treatment effect on the scale of odds ratios
(default=\code{1.2}).}
\item{K}{Number of experimental treatments (default=\code{4}).}
\item{J}{Number of stages (default=\code{2}).}
\item{alpha}{One-sided familywise error rate (default=\code{0.05}).}
\item{power}{Desired power (default=\code{0.9}).}
\item{r}{Vector of allocation ratios (default=\code{1:2}).}
\item{r0}{Vector ratio on control (default=\code{1:2}).}
\item{ushape}{Shape of upper boundary. Either a function specifying the
shape or one of \code{"pocock"}, \code{"obf"} (the default),
\code{"triangular"} and \code{"fixed"}.}
\item{lshape}{Shape of lower boundary. Either a function specifying the
shape or one of \code{"pocock"}, \code{"obf"}, \code{"triangular"} and
\code{"fixed"} (the default).}
\item{ufix}{Fixed upper boundary (default=\code{NULL}). Only used if
\code{shape="fixed"}.}
\item{lfix}{Fixed lower boundary (default=\code{0}). Only used if
\code{shape="fixed"}.}
\item{nstart}{Starting point for finding the sample size
(default=\code{1}).}
\item{nstop}{Stopping point for finding the sample size
(default=\code{NULL}).}
\item{sample.size}{Logical if sample size should be found as well
(default=\code{TRUE}).}
\item{N}{Number of quadrature points per dimension in the outer integral
(default=\code{20}).}
\item{parallel}{if \code{TRUE} (default), allows parallelisation of the
computation via a user-defined strategy specified by means of the function
\code{\link[future:plan]{future::plan()}}. If not set differently,
the default strategy is \code{sequential}, which corresponds to a
computation without parallelisation.}
\item{print}{if \code{TRUE} (default), indicate at which stage the
computation is.}
}
\description{
The function determines (approximately) the boundaries of a
multi-arm multi-stage study with ordinal or binary endpoints for a given
boundary shape and finds the required number of subjects.
}
\details{
This function finds the (approximate) boundaries and sample size of
a multi-arm multi-stage study with ordinal or binary endpoints with K active
treatments plus control in which all promising treatments are continued at
interim analyses as described in Magirr et al (2012). It is a wrapper around
the basic mams function to facilitate its use with ordinal and binary
endpoints, following ideas of Whitehead & Jaki (2009) and Jaki & Magirr
(2013). For a binary endpoint the vector prob has only two elements
(success/failure, yes/no, etc.). See mams for further details on the basic
methodology.
}
\examples{
\donttest{
## An example based on the example in Whitehead & Jaki (2009)
# 2-stage design with triangular efficacy and futility boundaries
prob <- c(0.075, 0.182, 0.319, 0.243, 0.015, 0.166)
ordinal.mams(prob=prob, or=3.06, or0=1.32, K=3, J=2, alpha=0.05,
                 power=0.9, r=1:2, r0=1:2, ushape="triangular",
                 lshape="triangular")
# same example with parallelisation via separate R sessions running in the
# background
future::plan(multisession)
ordinal.mams(prob=prob, or=3.06, or0=1.32, K=3, J=2, alpha=0.05,
                 power=0.9, r=1:2, r0=1:2, ushape="triangular",
                 lshape="triangular", parallel=TRUE)
future::plan("default")
}
}
\references{
Jaki T., Pallmann P. and Magirr D. (2019), The R Package MAMS for Designing
Multi-Arm Multi-Stage Clinical Trials, Journal of Statistical Software,
88(4), 1-25. Link: doi:10.18637/jss.v088.i04

Magirr D., Jaki T. and Whitehead J. (2012), A generalized Dunnett test for
multi-arm multi-stage clinical studies with treatment selection, Biometrika,
99(2), 494-501. Link: doi:10.1093/biomet/ass002

Magirr D., Stallard N. and Jaki T. (2014), Flexible sequential designs for
multi-arm clinical trials, Statistics in Medicine, 33(19), 3269-3279. Link:
doi:10.1002/sim.6183

Pocock S.J. (1977), Group sequential methods in the design and analysis of
clinical trials, Biometrika, 64(2), 191-199.

O'Brien P.C., Fleming T.R. (1979), A multiple testing procedure for clinical
trials, Biometrics, 35(3), 549-556.

Whitehead J. (1997), The Design and Analysis of Sequential Clinical Trials,
Wiley: Chichester, UK.
}
\author{
Philip Pallmann
}
