% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{o2cons}
\alias{o2cons}
\title{Oxygen Consumption of Leukocytes}
\format{
A data frame with 144 rows and 5 variables:
\describe{
  \item{O2}{oxygen consumption of leukocytes in \eqn{\mu}l}
  \item{Staphylococci}{whether or not inactivated staphylococci were added, 1 denotes yes, 0 no}
  \item{Time}{the measurements were taken after 6, 12 and 18 minutes}
  \item{Group}{the treatment group, either P for Placebo or V for Verum}
  \item{Subject}{the subject id}
}
}
\source{
Friedrich, S., Brunner, E. & Pauly, M. (2017). 
Permuting longitudinal data in spite of the dependencies. 
Journal of Multivariate Analysis, 153, 255-265.
}
\usage{
data(o2cons)
}
\description{
A dataset containing measurements on the oxygen consumption of leukocytes in the presence and absence of inactivated staphylococci.
}
\examples{
  library(ggplot2)
  ggplot(o2cons, aes(x=Group, y=O2)) + geom_point(alpha=0.5) + facet_grid(Staphylococci~Time) +
  stat_summary(fun.y = mean, fun.ymin = min, fun.ymax = max, colour = "red") 

}
\keyword{datasets}
