% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_03_6_CompareValues_GO.R
\name{BioPathways}
\alias{BioPathways}
\title{Gene Ontology Analysis}
\usage{
BioPathways(MarvelObject, psi.de.sig, method.adjust, min.genes,
  p.val.adj.return, plot.top.n)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CompareValues} function.}

\item{psi.de.sig}{Numeric value. Adjusted p-value below which the splicing event is considered differentially spliced and included for isoform switching analysis.}

\item{method.adjust}{Character string. Adjust p-values for multiple testing. Options available as per \code{p.adjust} function.}

\item{min.genes}{Numeric value. Number of differentially spliced genes required for analysis.}

\item{p.val.adj.return}{Numeric value. Return pathways with adjusted p-value below this value.}

\item{plot.top.n}{Numeric value. Plot these top most significant pathways.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to two new slots. \code{$DE$BioPathways} contains the pathways significantly enriched among differentially spliced genes as specified in \code{p.val.adj.return}. \code{$DE$BioPathwaysPlot} contains the plot of top most significant pathways ranked by adjusted p-values as specified in \code{plot.top.n}.
}
\description{
\code{BioPathways} performs gene ontology analysis on genes that are differentially spliced.
}
\details{
This function performs gene ontology analysis on genes that are differentially spliced to identify significantly regulated biological pathways.
}
\examples{
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

marvel <- BioPathways(MarvelObject=marvel,
                      psi.de.sig=0.05,
                      method.adjust="fdr",
                      min.genes=50,
                      p.val.adj.return=0.05,
                      plot.top.n=10
                      )

marvel$DE$BioPathways
marvel$DE$BioPathwaysPlot
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
