% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_07_PREDICT_NMD_8_AnnoVolcanoPlot.R
\name{AnnoVolcanoPlot}
\alias{AnnoVolcanoPlot}
\title{Annotate Volcano Plot with Nonsense-Mediated Decay (NMD) Genes}
\usage{
AnnoVolcanoPlot(
  MarvelObject,
  anno = FALSE,
  gene.label.x.below = NULL,
  gene.label.y.above = NULL,
  gene.label.size = NULL
)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CompareExpr} function.}

\item{anno}{Logical value. If set to \code{TRUE}, selected gene names will be annotated on the plot as defined in \code{gene.label.x.below} and \code{gene.label.y.above}.}

\item{gene.label.x.below}{Numeric value. Only applicable when \code{anno} set to \code{TRUE}. To indicate log2(fold change) value below which the NMD genes are annotated on the plot. Specified together with \code{gene.label.y.above}.}

\item{gene.label.y.above}{Numeric value. Only applicable when \code{anno} set to \code{TRUE}. To indicate -log10(p-value) above which the NMD genes are annotated on the plot. Specified together with \code{gene.label.x.below}.}

\item{gene.label.size}{Numeric value. Indicate size of gene labels specified using \code{gene.label.x.below} and \code{gene.label.y.above}.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to one new slot named \code{MarvelObject$NMD$AnnoVolcanoPlot}.
}
\description{
\code{AnnoVolcanoPlot} plots annotates volcano plot generated from differential gene expression analysis with genes predicted to undergo splicing-induced NMD.
}
\details{
This function plots and annotates volcano plot generated from differential gene expression analysis with genes predicted to undergo splicing-induced NMD. Helpful to look for NMD genes based on degree of log2(fold change) and adjusted p-values. NMD genes with large log2(fold change) and small adjusted p-values may be of interest.
}
\examples{
# Load input
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Run example
marvel <- AnnoVolcanoPlot(MarvelObject=marvel)

# Check output
marvel$NMD$AnnoVolcanoPlot$Table[1:5, ]
marvel$NMD$AnnoVolcanoPlot$Plot
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
