% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_09_PREDICT_NMD_7_CompareExpr.R
\name{CompareExpr}
\alias{CompareExpr}
\title{Compares gene expression changes based on nonsense-mediated decay (NMD) status}
\usage{
CompareExpr(MarvelObject, xlabels.size = 8)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{FindPTC} function.}

\item{xlabels.size}{Numeric value. Size of the x-axis tick labels. Default is 8.}
}
\value{
An object of class S3 new slots \code{MarvelObject$NMD$NMD.Expr$Table}, \code{MarvelObject$NMD$NMD.Expr$Plot}, and \code{MarvelObject$NMD$NMD.Expr$Plot.Stats}.
}
\description{
Compares gene expression changes based on NMD status for each splicing event type.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- CompareExpr(MarvelObject=marvel.demo)

# Check outputs
head(marvel.demo$NMD$NMD.Expr$Table)
marvel.demo$NMD$NMD.Expr$Plot
marvel.demo$NMD$NMD.Expr$Plot.Stats
}
