% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_cox.R
\name{box_cox}
\alias{box_cox}
\alias{box_cox,formula-method}
\alias{box_cox,lm-method}
\alias{plot.box_cox}
\alias{print.box_cox}
\title{Box-cox constructor function}
\usage{
box_cox(object, ...)

\S4method{box_cox}{formula}(object, data = sys.parent(), ...)

\S4method{box_cox}{lm}(object, ..., plotit, flap = 0.4)

\method{plot}{box_cox}(
  x,
  ...,
  las = 1,
  xlab = expression(lambda),
  ylab,
  col.lines = "steel blue"
)

\method{print}{box_cox}(
  x,
  ...,
  las = 1,
  xlab = expression(lambda),
  ylab,
  col.lines = "steel blue"
)
}
\arguments{
\item{object}{either a \code{"box_cox"} object, a formula,data pair, a linear model object or an xy-lixt}

\item{...}{additional arguments passed on to methods}

\item{data}{a data frame or environment}

\item{plotit}{currently ignored.  Plotting is done by \code{plot} or \code{print} methods}

\item{flap}{fraction of the central 95\% notional confidence to expand the range of lambda for the display}

\item{x}{a \code{"box_cox"} object to be displayed}

\item{xlab, ylab, las}{as for \code{plot}}

\item{col.lines}{colour to use for indicator lines in the display}
}
\value{
an object of class \code{"box_cox"}
}
\description{
A front-end to \code{\link[MASS]{boxcox}} with slicker display and better defaults
}
\examples{
box_cox(MPG.city ~ Weight, Cars93)
}
