% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.MBPLS.R
\name{plot.MBPLS}
\alias{plot.MBPLS}
\title{Main Graphs for Multiblock Partial Least Squares (MB-PLS) regression}
\usage{
\method{plot}{MBPLS}(
  x,
  axes = c(1, 2),
  graphtype = c("globalscores", "blockscores", "globalcor", "blockcor", "explY",
    "cumexplY", "explX", "cumexplX", "crit", "contrib"),
  select = NULL,
  max.overlaps = 20,
  xlim = NULL,
  ylim = NULL,
  title = NULL,
  color = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{MBPLS}.}

\item{axes}{A vector of length two which specifies the global components to plot (by default the first two).}

\item{graphtype}{Type of graph to plot. Either "globalscores", "blockscores","globalcor","blockcor", "explY", "cumexplY", "explX", "cumexplX", "crit" or "contrib".
Refer to the details section.}

\item{select}{Selection of elements to plot (by default, select=NULL). Refer to the details section.}

\item{max.overlaps}{Exclude text labels that overlap too many things (by default, 20).}

\item{xlim}{Range for the plotted 'x' values.}

\item{ylim}{Range for the plotted 'y' values.}

\item{title}{Title of the graph to draw.}

\item{color}{Color for the plot.}

\item{...}{Further arguments.}
}
\value{
Returns graphs showing the projection of individuals in both global and block components, the correlations of variables with the global and block components,
the percentages of inertia of both Y block and X blocks explained by the global components and their cumulative values, the values of the maximization criterion and the contributions of the blocks
to the determination of global components.
}
\description{
Plot the main graphs for MB-PLS regression.
}
\details{
The arguments graphtype and select are used as follow.\cr
If graphtype="globalscores", individuals are projected on the space formed by the global components.\cr
In this case, if for example, select=NULL, all the individuals are plotted. However, if select=5, only the first five individuals are plotted.\cr
If graphtype="blockscores", individuals are projected on the space formed by the block components.\cr
If select=NULL, individuals of each block are plotted on separate figures.\cr
If select=c(1,3), individuals of blocks 1 and 3 are plotted on separate figures.\cr
If graphtype="globalcor", correlations of original variables with the global components are depicted.\cr
If select=NULL, correlations of the variables of all the blocks are plotted on the same figure.\cr
If select=c(1,3), correlations of the variables of blocks 1 and 3 are plotted.\cr
If graphtype="blockcor", correlations of original variables with the block components are depicted.\cr
If select=NULL, correlations of the variables of each block are plotted on seperate figures.\cr
If select=c(1,3), correlations of the variables of blocks 1 and 3 are plotted.\cr
If graphtype="explY", percentages of inertia of Y block explained by the global components are drawn.\cr
If graphtype="cumexplY", cumulative percentages of inertia of Y block explained by the global components are drawn.\cr
If graphtype="explX", percentages of inertia of X blocks explained by the global components are drawn.\cr
If graphtype="cumexplX", cumulative percentages of inertia of X blocks explained by the global components are drawn.\cr
graphtype="crit" plots the values of the maximization criterion.\cr
graphtype="contrib" depicts the contribution of each block of variables to the determination of the global components.\cr
For graphtype="explY", "cumexplY", "explX", "cumexplX", "crit" and "contrib", if select=NULL, all the dimensions are plotted. \cr
But if for example, select=5, only the first five dimensions are plotted.\cr
}
\examples{
data(ham)
X=ham$X
Y=ham$Y
group=ham$group
res.mbpls <- MBPLS(X, Y, group, plotgraph=FALSE)
plot(res.mbpls, graphtype="globalscores")
plot(res.mbpls, graphtype="globalcor")


}
\seealso{
\code{\link{MBPLS}}
}
\author{
Essomanda TCHANDAO MANGAMANA \email{tchanesso@yahoo.fr}, Véronique CARIOU, Evelyne VIGNEAU.
}
