% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.functions.R
\name{write.likelihood}
\alias{write.likelihood}
\title{Adds sections of JAGS code for an MBNMA model that correspond to the
likelihood}
\usage{
write.likelihood(model, timecourse, rho = NULL, covar = NULL)
}
\arguments{
\item{model}{A character object of JAGS MBNMA model code}

\item{timecourse}{A character object representing the time-course used in the MBNMA model}

\item{rho}{The correlation coefficient when modelling correlation between time points. If left
as \code{NULL} (the default) then this implies modelling no correlation between time points.
Can either be assigned the string \code{"estimate"} to indicate that rho should be estimated
from the data, or assigned a numeric value, which fixes \code{rho} in the model to the assigned
value, either for when \code{rho} is calculated externally or for use in deterministic sensitivity
analyses.}

\item{covar}{A character specifying the covariance structure to use for the
multivariate normal likelihood. Can currently take either \code{"CS"} (compound
symmetry) or \code{"AR1"} (autoregressive AR1).}
}
\value{
A character object of JAGS MBNMA model code that includes likelihood
components of the model
}
\description{
Adds sections of JAGS code for an MBNMA model that correspond to the
likelihood
}
