% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.functions.R
\name{mb.update}
\alias{mb.update}
\title{Update MBNMA to obtain deviance contributions or fitted values}
\usage{
mb.update(mbnma, param = "theta", n.iter = mbnma$BUGSoutput$n.iter,
  n.thin = mbnma$BUGSoutput$n.thin)
}
\arguments{
\item{mbnma}{An S3 object of class \code{"mbnma"} generated by running
a time-course MBNMA model}

\item{param}{A character object that represents the parameter within the model to monitor when updating. Can
currently only be used for monitoring fitted values and deviance contributions and so can take
either \code{"dev"} (for deviance contributions), \code{"resdev"} (for residual deviance contributions)
or \code{"theta"} (for fitted values).}

\item{n.iter}{The number of iterations to update the model whilst monitoring additional parameters (if necessary).
Must be a positive integer. Default is the value used in \code{mbnma}.}

\item{n.thin}{The thinning rate. Must be a positive integer. Default is the value used in \code{mbnma}.}
}
\value{
A data frame containing posterior means for the specified \code{param} at each observation, arm and study.
}
\description{
Update MBNMA to obtain deviance contributions or fitted values
}
\examples{
\donttest{
# Using the alogliptin dataset
network <- mb.network(alog_pcfb)

# Run Emax model
emax <- mb.emax(network)

# Update model for 500 iterations to monitor fitted values
mb.update(emax, param="theta", n.iter=500)

# Update model for 500 iterations to monitor residual deviance contributions
mb.update(emax, param="resdev", n.iter=500)

# Update model for 500 iterations to monitor deviance contributions
mb.update(emax, param="dev", n.iter=500)
}
}
