% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.functions.R
\name{getnmadata}
\alias{getnmadata}
\title{Prepares NMA data for JAGS}
\usage{
getnmadata(data.ab, link = "identity", sdscale = FALSE)
}
\arguments{
\item{data.ab}{A data frame of arm-level data in "long" format containing the columns:
\itemize{
\item \code{studyID} Study identifiers
\item \code{time} Numeric data indicating follow-up times
\item \code{y} Numeric data indicating the aggregate response for a given observation (e.g. mean)
\item \code{se} Numeric data indicating the standard error for a given observation
\item \code{treatment} Treatment identifiers (can be numeric, factor or character)
\item \code{class} An optional column indicating a particular class identifier. Observations with the same treatment
identifier must also have the same class identifier.
\item \code{n} An optional column indicating the number of participants used to calculate the
response at a given observation (required if modelling using Standardised Mean Differences)
\item \code{standsd} An optional column of numeric data indicating reference SDs used to standardise
treatment effects when modelling using Standardised Mean Differences (SMD).
}}

\item{link}{Can take either \code{"identity"} (the default),
\code{"log"} (for modelling Ratios of Means \insertCite{friedrich2011}{MBNMAtime}) or
\code{"smd"} (for modelling Standardised Mean Differences - although this also corresponds to an identity link function).}

\item{sdscale}{Logical object to indicate whether to write a model that specifies a reference SD
for standardising when modelling using Standardised Mean Differences. Specifying \code{sdscale=TRUE}
will therefore only modify the model if link function is set to SMD (\code{link="smd"}).}
}
\value{
A named list of numbers, vector, matrices and arrays to be sent to
JAGS. List elements are:
\itemize{
\item \code{y} An array of mean responses for each observation in each arm within each study
\item \code{se} An array of standard errors for each observation in each arm within each study
\item \code{narm} A numeric vector with the number of arms per study
\item \code{NS} The total number of studies in the dataset
\item \code{NT} The total number of treatments in the dataset
\item \code{treat} A matrix of treatment codes within each study
}
}
\description{
Converts data frame to a list for use in JAGS NMA model
}
\examples{
# Using the alogliptin dataset
network <- mb.network(alog_pcfb)

# Construct a dataset with the latest time point in each study
data.ab <- get.latest.time(network)$data.ab
getnmadata(data.ab)

}
