\name{ElectreTRIBM}
\alias{ElectreTRIBM}

\title{Electre TRI-like sorting method axiomatized by Bouyssou and Marchant.}

\description{This simplification of the Electre TRI method uses the pessimistic assignment rule, without indifference or
preference thresholds attached to criteria. Only a binary discordance condition is considered, i.e. a veto forbids an outranking in any possible concordance situation, or not.}

\usage{
ElectreTRIBM(performanceTable, categoriesLowerProfiles, 
            criteriaWeights, criteriaMinMax, majorityThreshold, 
            criteriaVetos = NULL, alternativesIDs = NULL, 
            criteriaIDs = NULL, categoriesIDs = NULL)
}

\arguments{
  \item{performanceTable}{Matrix or data frame containing the performance table. Each row corresponds to an alternative, and each column to a criterion. Rows (resp. columns) must be named according to the IDs of the alternatives (resp. criteria).}
  \item{categoriesLowerProfiles}{Matrix containing, in each row, the lower profiles of the categories. The columns are named according to the criteria, and the rows are named according to the categories. The index of the row in the matrix corresponds to the rank of the category.}
  \item{criteriaWeights}{Vector containing the weights of the criteria. The elements are named according to the IDs of the criteria.}
  \item{criteriaMinMax}{Vector containing the preference direction on each of the criteria. "min" (resp. "max") indicates that the criterion has to be minimized (maximized). The elements are named according to the IDs of the criteria.}
  \item{majorityThreshold}{The cut threshold for the concordance condition. Should be at least half of the sum of the weights.}
  \item{criteriaVetos}{Matrix containing in each row a vector defining the veto values for the lower profile of the category. NA values mean that no veto is defined. A veto threshold for criterion i and category k represents the performance below which an alternative is forbidden to outrank the lower profile of category k, and thus is forbidden to be assigned to the category k. The rows are named according to the categories, whereas the columns are named according to the criteria.}
  \item{alternativesIDs}{Vector containing IDs of alternatives, according to which the datashould be filtered.}
  \item{criteriaIDs}{Vector containing IDs of criteria, according to which the data should be filtered.}
  \item{categoriesIDs}{Vector containing IDs of categories, according to which the data should be filtered.}
}

\value{
  The function returns a vector containing the assignments of the alternatives to the categories. 
}

\references{
Bouyssou, D. and Marchant, T. An axiomatic approach to noncompen-
satory sorting methods in MCDM, II: more than two categories. European Journal
of Operational Research, 178(1): 246--276, 2007.
}

\examples{
# the performance table

performanceTable <- rbind(
  c(1,10,1),
  c(4,20,2),
  c(2,20,0),
  c(6,40,0),
  c(30,30,3))

rownames(performanceTable) <- c("RER","METRO1","METRO2","BUS","TAXI")

colnames(performanceTable) <- c("Price","Time","Comfort")

# lower profiles of the categories 
# (best category in the first position of the list)

categoriesLowerProfiles <- rbind(c(3, 11, 3),c(7, 25, 2),c(NA,NA,NA))

colnames(categoriesLowerProfiles) <- colnames(performanceTable)

rownames(categoriesLowerProfiles)<-c("Good","Medium","Bad")

# criteria to minimize or maximize

criteriaMinMax <- c("min","min","max")

names(criteriaMinMax) <- colnames(performanceTable)

# vetos

criteriaVetos <- rbind(c(10, NA, NA),c(NA, NA, 1),c(NA,NA,NA))

colnames(criteriaVetos) <- colnames(performanceTable)
rownames(criteriaVetos) <- c("Good","Medium","Bad")

# weights

criteriaWeights <- c(1,3,2)

names(criteriaWeights) <- colnames(performanceTable)


# ElectreTRIBM

assignments<-ElectreTRIBM(performanceTable, categoriesLowerProfiles, 
                          criteriaWeights, criteriaMinMax, 3, 
                          criteriaVetos = criteriaVetos)
 
print(assignments)

# un peu de filtrage

assignments<-ElectreTRIBM(performanceTable, categoriesLowerProfiles, 
                          criteriaWeights, criteriaMinMax, 2, 
                          categoriesIDs = c("Medium","Bad"), 
                          criteriaIDs = c("Price","Time"), 
                          alternativesIDs = c("RER", "BUS"))

print(assignments)

}

\keyword{methods}
%\keyword{ ~~ other possible keyword(s)}
