% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powMCTGen.R
\name{planModPrepare}
\alias{planModPrepare}
\title{Return the S Matrix for a Theoretical DR-Curve}
\usage{
planModPrepare(
  nSample,
  family = c("negative binomial", "binomial", "poisson"),
  link = c("log", "logit", "sqrt", "probit", "cauchit", "cloglog", "identity",
    "risk ratio", "log risk ratio"),
  modelPar = NULL,
  theoResp = NULL,
  doses = NULL,
  Ntype = c("arm", "total", "actual"),
  alRatio = NULL,
  placEff = NULL,
  models = NULL,
  verbose = FALSE,
  offset = NULL
)
}
\arguments{
\item{nSample}{An integer if \code{Ntype} is 'arm' or 'total', or a numerical
vector of patient allocations for each arm if \code{Ntype} is 'actual'.}

\item{family}{A character string containing the error distribution to be used
in the model.}

\item{link}{A character string for the model link function.}

\item{modelPar}{A numeric vector containing the additional parameters for the
family argument. If the family is negative binomial, the dispersion
parameter should be supplied. If the family is binomial, no model parameter
should be supplied.}

\item{theoResp}{A numerical vector of theoretical response values, on the
transformed scale (e.g. on the log-scale for the negative binomial family).
This should be the same length as the doses argument.}

\item{doses}{A numerical vector of doses, corresponding to the theoretical
response values provided.}

\item{Ntype}{One of 'arm', 'total', or 'actual'. See documentation for
\code{Ntype} in \code{\link[DoseFinding:powMCT]{powMCT}} for descriptions
of 'arm' and 'total'. For 'actual', the nSample should be a numerical
vector containing the actual patient allocation for each dose provided.}

\item{alRatio}{A numeric vector specifying the ratios between the patient
allocation for the specified doses.}

\item{placEff}{A numeric value of the placebo effect. This is needed only
when the link is risk ratio.}

\item{models}{Instead of supplying a theoretical dose-response curve and
doses, an object of class \code{Mods} may be provided. The doses will be
pulled from this object, along with the responses at the doses.}

\item{verbose}{A logical specifying whether the patient allocation should be
printed, in addition to the results.}

\item{offset}{A positive numeric value specifying the offset term for the
negative binomial distribution. If offset = NULL (the default), then the
offset has no effect. Theoretically, the offset should be a numeric vector
the same length as the number of observations, but for planning purposes,
it is unlikely to know the individual offsets in advance.}
}
\value{
A numeric S matrix, or a list S matrices, for each model is
  \code{models}.
}
\description{
This function is useful for several \code{DoseFinding} functions, but
particular for \code{planMod}. Given the true dose-response curve at
specified doses, this function will calculate and return the S matrix
associated with the specified distribution. If an object of class \code{Mods}
is provided in the \code{models} argument, then a list of S matrices will be
returned.
}
\examples{
dose.vec = c(0, 5, 10, 20, 30, 40)
models.full = Mods(doses = dose.vec, linear = NULL,
      sigEmax = rbind(c(9, 2), c(6, 3)),
      emax = 0.8,
      quadratic = -0.02,
      placEff = 0, maxEff = 2)
planModPrepare(30, 'negative binomial', 'log', 0.3, getResp(models.full)[,3],
      dose.vec, 'arm')
}
