% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCPwrite.R
\name{MCPwrite}
\alias{MCPwrite}
\title{Export the results of the \code{MCPtest} function.}
\usage{
MCPwrite(x, MCP = "all", extension = "csv", dataMR = "all")
}
\arguments{
\item{x}{object from the \code{MCPtest} functions.}

\item{MCP}{Allows choosing the multiple comparison test.
The \emph{defaut} is "all". This option will go perform all tests
from the \code{MCPtest} object.}

\item{extension}{Type of format of the file. Four options
\code{"csv"}, \code{"txt"} \code{"xlsx"} and \code{"latex"}.
 The \emph{default} is \code{"csv"}.}

\item{dataMR}{Allows to choose the results to bee written. Three options are
available: \code{"groups"}, \code{"summary"} or \code{"all"}. The option
\code{"groups"} writes the treatment mean groups avaluated by the chosen test
in the \code{MCP} argument.  The \code{"summary"} writes the descriptive
statistics of the response variable. The options \code{"all"} should be chosen
for both results.}
}
\value{
\code{MCPwrite} writes the most important results for the chosen
    tests in the \code{MCP} argument.
}
\description{
The \code{x} object from a \code{MCPtest} is written to file arguments.
}
\details{
Note that the choice of the tests in the \code{MCPwrite}
    function must be in accordance with the tests chosen
    in the \code{x} argument.
}
\examples{
# Simulated data (completely randomized design)

rv <- c(100.08, 105.66, 97.64, 100.11, 102.60, 121.29, 100.80,
        99.11, 104.43, 122.18, 119.49, 124.37, 123.19, 134.16,
        125.67, 128.88, 148.07, 134.27, 151.53, 127.31)

# Treatments
treat <- factor(rep(LETTERS[1:5], each = 4))

# Anova
res <- aov(rv~treat)

# Loading the MCPtests package
library(MCPtests)

# Choosing any tests
results <- MCPtest(y = res, trt = "treat", alpha = 0.05,
                   main = "Multiple Comparison Procedures",
                   MCP = c("MGM", "TM"))

#Export file in latex (Output in Console)
MCPwrite(results, MCP = "all", extension = "latex", dataMR = "all")

#Observation: The MCPwrite function export
#             only one extension at a time
}
