% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop1.geeglm.R
\name{drop1.geeglm}
\alias{drop1.geeglm}
\title{Drop All Possible Single Terms to a geeglm Model Using Wald Test}
\usage{
\method{drop1}{geeglm}(object, scope, test = c("Wald", "none", "score",
  "sasscore"), method = c("robust", "naive", "sandwich"), ...)
}
\arguments{
\item{object}{a fitted object of class geese.}

\item{scope}{a formula giving the terms to be considered for adding or dropping.}

\item{test}{the type of test to include.}

\item{method}{Indicates which method is used for computing the standard
error. \code{robust} is the default and corresponds to the modified sandwich
estimator. \code{naive} is the classical naive cariance estimate.
\code{sandwich} is an alias for \code{robust}.}

\item{\dots}{other arguments. Not currently used}
}
\value{
An object of class "anova" summarizing the differences in fit
between the models.
}
\description{
Compute all the single terms in the scope argument that can dropped from the
model, and compute a table of the corresponding Wald test statistics.
}
\examples{

library(geepack)
data(ohio)
fit <- geeglm(resp ~ age + smoke + age:smoke, id=id, data=ohio,
             family=binomial, corstr="exch", scale.fix=TRUE)
drop1(fit)

}
\author{
Claus Ekstrom \email{claus@ekstroem.dk}
}
\seealso{
\code{\link{drop1}}, \code{geeglm}, \code{geese}
}
\keyword{htest}

