% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_random_forest.R
\name{MFKnockoffs.stat.random_forest}
\alias{MFKnockoffs.stat.random_forest}
\title{Random forest statistics for MFKnockoffs}
\usage{
MFKnockoffs.stat.random_forest(X, X_k, y, ...)
}
\arguments{
\item{X}{original design matrix (size n-by-p)}

\item{X_k}{knockoff matrix (size n-by-p)}

\item{y}{response vector (length n). If a factor, classification is assumed, 
otherwise regression is assumed.}

\item{...}{additional arguments specific to 'ranger' (see Details)}
}
\value{
A vector of statistics \eqn{W} (length p)
}
\description{
Computes the difference statistic
  \deqn{W_j = |Z_j| - |\tilde{Z}_j|}
where \eqn{Z_j} and \eqn{\tilde{Z}_j} are the random forest feature importances
of the jth variable and its knockoff, respectively.
}
\details{
This function uses the \code{ranger} package to compute variable 
importance measures. The importance of a variable is measured as the total decrease
in node impurities from splitting on that variable, averaged over all trees. 
For regression, the node impurity is measured by residual sum of squares.
For classification, it is measured by the Gini index.

For a complete list of the available additional arguments, see \link[ranger]{ranger}.
}
\examples{
p=100; n=200; k=15
mu = rep(0,p); Sigma = diag(p)
X = matrix(rnorm(n*p),n)
nonzero = sample(p, k)
beta = 3.5 * (1:p \%in\% nonzero)
y = X \%*\% beta + rnorm(n)

knockoffs = function(X) MFKnockoffs.create.gaussian(X, mu, Sigma)
# Basic usage with default arguments
result = MFKnockoffs.filter(X, y, knockoffs=knockoffs, 
                           statistic=MFKnockoffs.stat.random_forest)
print(result$selected)

# Advanced usage with custom arguments
foo = MFKnockoffs.stat.random_forest
k_stat = function(X, X_k, y) foo(X, X_k, y, nodesize=5)
result = MFKnockoffs.filter(X, y, knockoffs=knockoffs, statistic=k_stat)
print(result$selected)

}
\seealso{
Other statistics for knockoffs: \code{\link{MFKnockoffs.stat.forward_selection}},
  \code{\link{MFKnockoffs.stat.glmnet_coef_difference}},
  \code{\link{MFKnockoffs.stat.glmnet_lambda_difference}},
  \code{\link{MFKnockoffs.stat.lasso_coef_difference_bin}},
  \code{\link{MFKnockoffs.stat.lasso_coef_difference}},
  \code{\link{MFKnockoffs.stat.lasso_lambda_difference_bin}},
  \code{\link{MFKnockoffs.stat.lasso_lambda_difference}},
  \code{\link{MFKnockoffs.stat.sqrt_lasso}},
  \code{\link{MFKnockoffs.stat.stability_selection}}
}
