% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GendataAFT.R
\name{GendataAFT}
\alias{GendataAFT}
\title{Generate simulation data (Survival data based on accelerated failure time model)}
\usage{
GendataAFT(n, p, rho, lambda = 0.1, beta = c(rep(1, 5), rep(0, p - 5)))
}
\arguments{
\item{n}{Number of subjects in the dataset to be simulated. It will also equal to the
number of rows in the dataset to be simulated, because it is assumed that each
row represents a different independent and identically distributed subject.}

\item{p}{Number of predictor variables (covariates) in the simulated dataset.
These covariates will be the features screened by model-free procedures.}

\item{rho}{The correlation between adjacent covariates in the simulated matrix X.
The within-subject covariance matrix of X is assumed to has the same form as an
AR(1) auto-regressive covariance matrix, although this is not meant to imply
that the X covariates for each subject are in fact a time series. Instead, it is just
used as an example of a parsimonious but nontrivial covariance structure. If
rho is left at the default of zero, the X covariates will be independent and the
simulation will run faster.}

\item{lambda}{This parameter control the censoring rate in survival data.
The censored time is generated by exponential distribution with mean 1/lambda. The default
is lambda=0.1.}

\item{beta}{A vector with length of n, which are the coefficients that you want to generate
about Linear model. The default is beta=(1,1,1,1,1,0,...,0)^T;}
}
\value{
the list of your simulation data
}
\description{
This function helps you quickly generate simulation data based on AFT model.
You just need to input the sample and dimension of the data
you want to generate and the covariance parameter pho.
}
\examples{
n=100;
p=200;
pho=0.5;
data=GendataAFT(n,p,pho)
}
\author{
Xuewei Cheng \email{xwcheng@csu.edu.cn}
}
