% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-CRISPR2MF.R
\name{cubeHomingDrive}
\alias{cubeHomingDrive}
\title{Inheritance Cube: CRISPR (Clustered Regularly Interspaced Short Palindromic Repeats) with 2 Resistance Alleles and maternal deposition}
\usage{
cubeHomingDrive(cM = 1, cF = 1, dF = 0, chM = 0, crM = 0,
  chF = 0, crF = 0, dhF = 0, drF = 0, eta = NULL, phi = NULL,
  omega = NULL, xiF = NULL, xiM = NULL, s = NULL)
}
\arguments{
\item{cM}{Male homing rate}

\item{cF}{Female homing rate}

\item{dF}{Female deposition homing rate}

\item{chM}{Male correct homing rate}

\item{crM}{Male resistance generating rate}

\item{chF}{Female correct homing rate}

\item{crF}{Female resistance generating rate}

\item{dhF}{Female correct deposition rate}

\item{drF}{Female resistance deposition rate}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
This is a sex-specific version of the original cube. It assumes that the construct
is on an autosome and there can be different male/female homing rates. It also has
maternal deposition, ie, when the male provides a W allele to a female with a H allele,
some portion are cut during oogenesis.
If the maternal d eposition parameters are zero (d* parameters), this is a normal
CRISPR drive
}
