% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kr.R
\name{kr}
\alias{kr}
\title{Khatri-Rao product of two matrices}
\usage{
kr(A, B, w, byrow = TRUE)
}
\arguments{
\item{A, B}{matrices. The two matrices \code{A} and \code{B} should have the same number of columns.
We also give the user an option to do row-wise Kronecker product, to avoid transpose.  
When doing row-wise Kronecker product, the number of rows of A and B should be the same.}

\item{w}{the weights vector. The length of the vector should match with the dimension of the matrices.
If performing column-wise Kronecker product, the length of w should be the same as the column number of A and B.  
If performing row-wise Kronecker prodoct, the length of w should be the same as the row number of A and B. 
The default is a vector of 1 if no value provided.}

\item{byrow}{a logical variable controlling whether to perform row/column-wise Kronecker product.
The default is \code{byrow}=TRUE.}
}
\value{
A matrix of the Khatri-Rao product.
}
\description{
Return the Khatri-Rao product of two matrices, which is a column-wise Kronecker product.
}
\details{
The column/row-wise Kronecker product.
}
\examples{
X <- matrix(rnorm(30), 10, 3)
Y <- matrix(runif(50), 10, 5)
C <- kr(X, Y)

}
\author{
Yiwen Zhang and Hua Zhou
}
