% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_Clustering.R
\name{ClustQual}
\alias{ClustQual}
\title{Cluster Quality}
\usage{
ClustQual(fit)
}
\arguments{
\item{fit}{Object of class mix.}
}
\value{
List containing the cluster quality metrics.
}
\description{
Evaluates cluster quality. Returns the following metrics:
\itemize{
\item BIC: Bayesian Information Criterion, lower value indicates better clustering quality.
\item CHI: Calinski-Harabaz Index, higher value indicates better clustering quality.
\item DBI: Davies-Bouldin, lower value indicates better clustering quality.
\item SIL: Silhouette Width, higher value indicates better clustering quality.
}
}
\examples{
set.seed(100)

# Data generation
mean_list = list(
c(2, 2, 2),
c(-2, 2, 2),
c(2, -2, 2),
c(2, 2, -2)
)

data <- rGMM(n = 500, d = 3, k = 4, means = mean_list)
fit <- FitGMM(data, k = 4)

# Clustering quality
cluster_qual <- ClustQual(fit)
}
\seealso{
See \code{\link{ChooseK}} for using quality metrics to choose the cluster number.
}
