% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpecFunctions_Final3.R
\name{simulate_poly_spectra}
\alias{simulate_poly_spectra}
\title{simulate_poly_spectra}
\usage{
simulate_poly_spectra(
  sim.template,
  mixture.ratio,
  spectrum.name = "Spectrum",
  mixture.missing.prob.peak = 0.05,
  noise.peak.ratio = 0.05,
  snr.basepeak = 500,
  noise.cv = 0.25,
  mz.range = c(1000, 2200)
)
}
\arguments{
\item{sim.template}{A data frame which contains m/z, log intensitiy, normalized intensity values and missing rates of peaks. There are also species and strain information. An object of \code{\link{create_insilico_mixture_template}}.}

\item{mixture.ratio}{A list of bacterial mixture ratios for given bacterial species in sim.template.}

\item{spectrum.name}{A character. An user can define the spectrum name. (Default: 'Spectrum').}

\item{mixture.missing.prob.peak}{A real value. The missing probability caused by mixing multiple bacteria species. (Default: 0.05)}

\item{noise.peak.ratio}{A ratio between the numbers of noise and signal peaks. (Default: 0.05)}

\item{snr.basepeak}{A (base peak) signal to noise ratio. (Default: 500)}

\item{noise.cv}{A coefficient of variation of noise peaks. (Default: 0.25)}

\item{mz.range}{A range of m/z values. (Default: c(1000,2200))}
}
\value{
A data frame that contains m/z values of peaks, normalized intensities of peaks, species names, and strain names. A modified version of \code{sim.template}.
}
\description{
This function takes simulated m/z and intensities of peaks from \code{\link{create_insilico_mixture_template}} and modifies them based on given parameters.
}
\examples{
spectra.processed.A <- process_monospectra(
   file=system.file("extdata", "listA.txt", package="MGMS2"),
   mass.range=c(1000,2200))
spectra.processed.B <- process_monospectra(
   file=system.file("extdata", "listB.txt", package="MGMS2"),
   mass.range=c(1000,2200))
spectra.processed.C <- process_monospectra(
   file=system.file("extdata", "listC.txt", package="MGMS2"),
   mass.range=c(1000,2200))
spectra.mono.summary.A <- summarize_monospectra(
   processed.obj=spectra.processed.A,
   species='A', directory=tempdir())
spectra.mono.summary.B <- summarize_monospectra(
   processed.obj=spectra.processed.B,
   species='B', directory=tempdir())
spectra.mono.summary.C <- summarize_monospectra(
   processed.obj=spectra.processed.C,
   species='C', directory=tempdir())
mono.info=gather_summary(c(spectra.mono.summary.A, spectra.mono.summary.B, spectra.mono.summary.C))
mixture.ratio <- list()
mixture.ratio['A']=1
mixture.ratio['B']=0.5
mixture.ratio['C']=0
sim.template <- create_insilico_mixture_template(mono.info)
insilico.spectrum <- simulate_poly_spectra(sim.template, mixture.ratio)
}
