% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateSamplesFas_func_20230321.R
\name{CreateSamplesFas}
\alias{CreateSamplesFas}
\title{CreateSamplesFas() function}
\usage{
CreateSamplesFas(seq_table, path_out)
}
\arguments{
\item{seq_table}{seq_table is a sequence table as output by the 'dada2'
pipeline, which has samples in rows and nucleotide sequence variants in
columns.}

\item{path_out}{is a user defined path to the folder where the output files
will be saved.}
}
\value{
A set of FASTA files with the sequences present in each sample in
  the sequence table.The sequences are named in the FASTA files by an index
  number corresponding to their column number in the sequence table, thus
  identical sequences will have identical sample names in all the FASTA
  files.
}
\description{
\code{\link{CreateSamplesFas}} creates a set of FASTA files with the
sequences present in each sample in a 'dada2' sequence table.
}
\details{
If you publish data or results produced with MHCtools, please cite both of
the following references:
Roved, J. 2022. MHCtools: Analysis of MHC data in non-model species. Cran.
Roved, J., Hansson, B., Stervander, M., Hasselquist, D., & Westerdahl, H. 2022.
MHCtools - an R package for MHC high-throughput sequencing data: genotyping,
haplotype and supertype inference, and downstream genetic analyses in non-model
organisms. Molecular Ecology Resources. https://doi.org/10.1111/1755-0998.13645
}
\examples{
seq_table <- sequence_table_fas
path_out <- tempdir()
CreateSamplesFas(seq_table, path_out)
}
\seealso{
\code{\link{CreateFas}}; for more information about 'dada2' visit
  <https://benjjneb.github.io/dada2/>
}
