% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HpltMatch_func_20230322.R
\name{HpltMatch}
\alias{HpltMatch}
\title{HpltMatch() function}
\usage{
HpltMatch(hplt_occ_matrix, path_out, threshold = NULL)
}
\arguments{
\item{hplt_occ_matrix}{A binary (logical) occurrence matrix with the data set
sequences in columns and the putative haplotypes in rows, as produced by the
CreateHpltOccTable() function.}

\item{path_out}{a user defined path to the folder where the output file(s) will
be saved.}

\item{threshold}{a numerical value between 0 and 1 (default NULL) specifying a
threshold for the proportion of matching sequences between haplotypes.}
}
\value{
A table specifying the proportions of matching sequences between
  pairs of haplotypes (in a lower left matrix). If a threshold value is
  specified, a list of haplotype matches where the proportion of matching
  sequences exceeds the threshold will be printed to the console. The list will
  also be saved in the output path, and can be reopened in R e.g. using the
  readRDS() function in the base package.
  Note: HpltMatch() will overwrite any existing files with the same output
  file names in path_out.
}
\description{
Putative haplotypes may be identical to each other, or they may differ only by
incongruent or unresolved sequences. It is therefore useful to curate putative
haplotypes by comparing them to identify potentially overlapping types as
candidates for further investigation. \code{\link{HpltMatch}} calculates the
proportion of matching sequences between pairs of haplotypes and produces a
.csv table with values in a lower left matrix. If a threshold value is
specified, a list of haplotype matches where the proportion of matching
sequences exceeds the threshold will be produced.
}
\details{
Note: The NestTablesXL() function provides a useful format for further
investigation of potentially overlapping haplotypes.

If you publish data or results produced with MHCtools, please cite both of
the following references:
Roved, J. 2022. MHCtools: Analysis of MHC data in non-model species. Cran.
Roved, J., Hansson, B., Stervander, M., Hasselquist, D., & Westerdahl, H. 2022.
MHCtools - an R package for MHC high-throughput sequencing data: genotyping,
haplotype and supertype inference, and downstream genetic analyses in non-model
organisms. Molecular Ecology Resources. https://doi.org/10.1111/1755-0998.13645
}
\examples{
hplt_occ_matrix <- hplt_occurrence_matrix
path_out <- tempdir()
HpltMatch(hplt_occ_matrix, path_out, threshold=NULL)
}
\seealso{
\code{\link{HpltFind}}; \code{\link{CreateHpltOccTable}};
  \code{\link{NestTablesXL}}
}
