# MHQoL: Mental Health Quality of Life Toolkit

This R-based toolkit is designed to facilitate the assessment, analysis and visualisation of Mental Health Quality of Life (MHQoL) data.

It provides several functions to compute standardised scores, use valuesets, and generate insightful visualisations, enabling researchers, clinicians and policymakers to better understand and improve mental health outcomes.

# Installation
You can install the development version of mhqol from GitHub with:

```{r}
install.packages("remotes")
remotes::install_github("tatooheene/mhqol")
```

# About the data
The package is based on the paper, manual and  of Krugten et al. (2022, 2024)

# References
-  van Krugten FCW, Busschbach JJV, Versteegh MM, Hakkaart-van Roijen L, Brouwer WBF. The Mental Health Quality of Life Questionnaire (MHQoL): development and first psychometric evaluation of a new measure to assess quality of life in people with mental health problems. Qual Life Res. 2022 Feb;31(2):633-643. doi: 10.1007/s11136-021-02935-w. Epub 2021 Jul 9. PMID: 34241821; PMCID: PMC8847188.

-  van Krugten FCW, Jonker MF, Himmler SFW, Hakkaart-van Roijen L, Brouwer WBF. Estimating a Preference-Based Value Set for the Mental Health Quality of Life Questionnaire (MHQoL). Med Decis Making. 2024 Jan;44(1):64-75. doi: 10.1177/0272989X231208645. Epub 2023 Nov 19. PMID: 37981788; PMCID: PMC10714713.
