% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fwer.ztest.R
\name{fwer.ztest}
\alias{fwer.ztest}
\title{Copula-based multiple z-test which controlls the FWER}
\usage{
fwer.ztest(sample, mu, sigma = NULL, sigLevel = 0.05)
}
\arguments{
\item{sample}{The observed sample}

\item{mu}{The mean \eqn{\mu^*}}

\item{sigma}{The estimated covariance matrix (the copula parameter). If it is omitted it will be estimated from an AR(1) model}

\item{sigLevel}{The desired significance level}
}
\value{
list l, where\itemize{
\item{l$statistic contains the values of the test statistics,}
\item{l$critvalues are the calibrated critical values,}
\item{l$test contains the test decisions,}
\item{l$etahat is estimated parameter of the Gumbel copula}}
}
\description{
Perform a multiple (two-sided) z-test controlling the family-wise error rate (FWER) using the procedure described in Stange, Bodnar, Dickhaus (2015).
}
\details{
Let \eqn{X_1,\cdots,X_n} denote an i.i.d. sample with values in \eqn{{\rm I\!R}^m}. Furthermore let \eqn{\mu_j={\rm I\!E}[X_{1,j}]} be the component-wise
expectations. Then the multiple (two-sided) z-test simultaneously tests the hypotheses \eqn{H_{0,j}: \mu_j = \mu_j^*} versus the corresponding alternatives \eqn{H_{1,j}: \mu_j\not=\mu_j^*}.

For usage examples and figure reproduction see \code{vignette('fwer-ztest',package='MHTcop')}.

Note: If the parameter \code{sigma} is passed it needs to be a consistent estimate of the covariance matrix of \eqn{X_1}.
}
\references{
J. Stange, T. Bodnar and T. Dickhaus (2015). Uncertainty quantification for the family-wise error rate in multivariate copula models. \emph{AStA Advances in Statistical Analysis} 99.3 (2015): 281-310.
}
