% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FWERSU.R
\name{Roth.p.adjust}
\alias{Roth.p.adjust}
\title{The adjusted p-values for Roth's step-up FWER controlling procedure.}
\usage{
Roth.p.adjust(p,p.set,digits)
}
\arguments{
\item{p}{numeric vector of p-values (possibly with \code{\link[base]{NA}}s). Any other R is coerced by \code{\link[base]{as.numeric}}. Same as in \code{\link[stats]{p.adjust}}.}

\item{p.set}{a list of numeric vectors, where each vector is the vector of all attainable p-values containing the available p-value for the corresponding hypothesis..}

\item{digits}{minimal number of significant digits for the adjusted p-values, the default value is 4, see \code{\link[base]{print.default}}.}
}
\value{
A numeric vector of the adjusted p-values (of the same length as \eqn{p}).
}
\description{
The function for calculating the adjusted p-values based on original available p-values and all attaianble p-values.
}
\examples{
p <- c(pbinom(1,8,0.5),pbinom(1,5,0.75),pbinom(1,6,0.6))
p.set <-list(pbinom(0:8,8,0.5),pbinom(0:5,5,0.75),pbinom(0:6,6,0.6))
Roth.p.adjust(p,p.set,digits=5)
}
\author{
Yalin Zhu
}
\references{
Roth, A. J. (1999).
Multiple comparison procedures for discrete test statistics.
\emph{Journal of statistical planning and inference}, \strong{82}: 101-117.
}

