% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testAUC.R
\name{testAUC}
\alias{testAUC}
\title{Calculate model AUC with test data.}
\usage{
testAUC(data, transformation, model)
}
\arguments{
\item{data}{Data frame containing test occurrence data in the first column
and corresponding explanatory variables in subsequent columns. The test
data should be coded as: 1/0/NA, representing presence, absence, and
unknown. See \code{\link{readData}}.}

\item{transformation}{Full pathway of the 'transformation.Rdata' file
containing the transformations used to build the model. This file is saved
as a result of the \code{\link{deriveVars}} function. Equivalently, the
second item in the list returned by \code{\link{deriveVars}} can be used
directly.}

\item{model}{Full pathway of the '.lambdas' file of the model in question.
This file is saved as a result of \code{\link{selectEV}}.}
}
\value{
In addition to returning the testAUC value, graphical output showing
  the corresponding ROC plot is produced. The point along the ROC curve where
  the discrimination threshold is PRO = 1 is shown for reference.
}
\description{
For a given model, \code{testAUC} calculates the Area Under the Curve (AUC)
of the Receiver Operating Characteristic (ROC) as a threshold-independent
measure of binary classification performance. This function is intended to be
used with occurence data that is independent from the data used to train the
model, to obtain an unbiased measure of model performance.
}
\examples{
\dontrun{
AUC <- testAUC(testdat,
   transformation = "D:/path/to/modeling/directory/deriveVars/transformations.Rdata",
   model = "D:/path/to/modeling/directory/selectEV/round/model/1.lambdas")
}

sp1pa <- sp1po
sp1pa$RV[is.na(sp1pa$RV)] <- 0
sp1pa[, 1] <- sample(sp1pa$RV, 40)
auc <- testAUC(sp1pa, DVs$transformations,
   system.file("extdata/sommerfeltia", "1.lambdas", package = "MIAmaxent"))
auc

\dontrun{
From vignette:
grasslandAUC <- testAUC(grasslandPA, transformation = grasslandDVs[[2]],
   model = system.file("extdata", "1.lambdas", package = "MIAmaxent"))
grasslandAUC
}

}

