% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIPW2.R
\name{aipw2}
\alias{aipw2}
\title{Estimate of linear regression parameter from AIPW2}
\usage{
aipw2(cvstr = "unstructured", Dep, Id, Time, m, n, data)
}
\arguments{
\item{cvstr}{"unstuctured","compound","ToE","AR1","markov",
"independence"}

\item{Dep}{column name of dependent variable in the dataset}

\item{Id}{column name of id of subjects in the dataset}

\item{Time}{column name of timepoints in the dataset}

\item{m}{starting column number of covariates}

\item{n}{ending column number of covariates}

\item{data}{balanced longitudinal data set where each subject's outcome has been measured at same time points and number
 of visits for each patient is same,
covariance structure of the outcome variable}
}
\value{
estimated parameter value for multiple linear regression model,AIC,BIC
}
\description{
provides augmented inverse probability weighted estimates of parameters for linear regression model
of response variable using different covariance structure
}
\details{
It uses the inverse probability weighted method to reduce the bias
due to missing covariate in linear regression model. The estimating equation is
\deqn{\sum_{i=1}^{k}\sum_{j=1}^{n}(\frac{\delta_{ij}}{\pi_{ij}}S(Y_{ij},\mathbf{X}_{ij},\mathbf{X}'_{ij})+(1-\frac{\delta_{ij}}{\pi_{ij}})\phi(\mathbf{V}=\mathbf{v}))=0}
where \eqn{\delta_{ij}=1} if there is missing  value in covariates and 0 otherwise,
\eqn{\mathbf{X}} is fully observed all subjects and \eqn{\mathbf{X}'} is partially missing,
 where \eqn{\mathbf{V}=(Y,\mathbf{X})} and \eqn{\pi_{ij}} are estimated value.
}
\examples{
data(srdata)
aipw2(cvstr="ToE",Dep="C6kine",Id="ID",Time="Visit",m=5,n=10,data=srdata)
}
\author{
Atanu Bhattacharjee,Bhrigu Kumar Rajbongshi and Gajendra K Vishwakarma
}
