% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_data.R
\name{import_activpal3_csv}
\alias{import_activpal3_csv}
\title{Import raw multi-channel accelerometer data stored in ActivPal3 csv format}
\usage{
import_activpal3_csv(filepath, header = FALSE)
}
\arguments{
\item{filepath}{string. The filepath of the input data.}

\item{header}{boolean. If TRUE, the input csv file will have column names in
the first row.}
}
\value{
dataframe. The imported multi-channel accelerometer signal, with the
  first column being the timestamps in POSXlct format, and the rest columns
  being accelerometer values in \eqn{g} unit.
}
\description{
\code{import_activpal3_csv} imports the raw multi-channel accelerometer data
stored in ActivPal3 csv format by converting the accelerometer values (in
digital voltage values) to \eqn{g} unit.
}
\details{
ActivPal 3 sensors have known dynamic range to be \eqn{(-2g, +2g)}. And the
sensor stores values using 8-bit memory storage. So, the digital voltage
values may be converted to \eqn{g} unit using following equation.

\deqn{x_g = \frac{x_{voltage} - 127}{2^8} * 4}
}
\section{How is it used in MIMS-unit algorithm?}{
 This function is a File IO
  function that is used to import data from ActivPal3 devices during
  algorithm validation.
}

\examples{
  default_ops = options()
  options(digits.secs=3)
  # Use the sample activpal3 csv file provided by the package
  filepath = system.file('extdata', 'activpal3.csv', package='MIMSunit')

  # Check the csv format
  readLines(filepath)[1:5]

  # Load the file, in our case without header
  df = import_activpal3_csv(filepath, header=FALSE)

  # Check loaded file
  head(df)

  # Check more
  summary(df)

  # Restore default options
  options(default_ops)
}
\seealso{
Other File I/O functions: 
\code{\link{export_to_actilife}()},
\code{\link{import_actigraph_count_csv}()},
\code{\link{import_actigraph_csv_chunked}()},
\code{\link{import_actigraph_csv}()},
\code{\link{import_actigraph_meta}()},
\code{\link{import_enmo_csv}()},
\code{\link{import_mhealth_csv_chunked}()},
\code{\link{import_mhealth_csv}()}
}
\concept{File I/O functions}
