% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_over_epoch.R
\name{aggregate_for_mims}
\alias{aggregate_for_mims}
\title{Aggregate over epoch to get numerically integrated values.}
\usage{
aggregate_for_mims(df, epoch, method = "trapz", rectify = TRUE, st = NULL)
}
\arguments{
\item{df}{dataframe of accelerometer data in mhealth format. First column
should be timestamps in POSIXt format.}

\item{epoch}{string. Any format that is acceptable by argument \code{breaks}
in method \code{\link[base]{cut.POSIXt}}.For example, "1 sec", "1 min", "5
secs", "10 mins".}

\item{method}{string. Integration methods. Supported strings include:
"trapz", "power", "sum", "meanBySecond", "meanBySize". Default is "trapz".}

\item{rectify}{logical. If TRUE, input data will be rectified before
integration. Default is TRUE.}

\item{st}{character or POSIXct timestamp. An optional start time you can set to
force the epochs generated by referencing this start time. If it is NULL, the
function will use the first timestamp in the timestamp column as start time to
generate epochs. This is useful when you are processing a stream of data and
want to use a common start time for segmenting data. Default is NULL.}
}
\value{
dataframe. The returned dataframe will have the same format as input
  dataframe.
}
\description{
\code{aggregate_for_mims} returns a dataframe with integrated values by
trapzoidal method over each epoch for each column. The epoch start time will
be used as timestamp in the first column.
}
\details{
This function accepts a dataframe (in mhealth accelerometer data format) and
computes its aggregated values over each fixed epoch using different
integration methods (default is trapzoidal method, other methods are not used
by mims unit algorithm) for each value columns. The returned dataframe will
have the same number of columns as input dataframe, and have the same
datetime format as input dataframe in the timestamp column. The trapzoidal
method used in the function is based on \code{\link[caTools]{trapz}}.
}
\note{
If \code{epoch} argument is not provided or is \code{NULL}, the
  function will treat the input dataframe as a single epoch.

  If the number of samples in one segment is less than 90% of the expected
  samples, the aggregation result will be -1 (marker of invalid value).
}
\section{How is it used in mims-unit algorithm?}{
 This function is used in
  mims-unit algorithm after filtering (\code{\link{iir}}). The filtered
  signal will be rectified and integrated to get mims unit values for each
  axis using this function.
}

\examples{
  # sample data
  df = sample_raw_accel_data
  head(df)

  # epoch set to 5 seconds, and method set to "trapz"
  aggregate_for_mims(df, epoch = '5 sec', method='trapz')

  # epoch set to 1 second, method set to "sum"
  aggregate_for_mims(df, epoch = '1 sec', method='sum')

  # epoch set to 1 second, and st set to be 1 second before the start time of the data
  # so the first segment will only include data for 1 second, therefore the resulted
  # aggregated value for the first segment will be -1 (invalid) because the
  # samples are not enough. And the second segment starts from 11:00:01, instead
  # of 11:00:02 as shown in prior example,
  aggregate_for_mims(df, epoch = '1 sec', method='sum', st=df[1,1] - 1)
}
\seealso{
\code{\link{aggregate_for_orientation}} for aggregating to get
  accelerometer orientation estimation for each epoch.

Other aggregate functions: 
\code{\link{aggregate_for_orientation}()}
}
\concept{aggregate functions}
