% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{illustrate_extrapolation}
\alias{illustrate_extrapolation}
\title{Plot illustrations about extrapolation in illustration style.}
\usage{
illustrate_extrapolation(
  df,
  dynamic_range,
  title = NULL,
  show_neighbors = TRUE,
  show_extrapolated_points_and_lines = TRUE,
  ...
)
}
\arguments{
\item{df}{data.frame.The original data before extrapolation.}

\item{dynamic_range}{numerical vector. The dynamic ranges of the input
signal. Should be a 2-element numerical vector. \code{c(low, high)}, where
\code{low} is the negative max value the device can reach and \code{high}
is the positive max value the device can reach.}

\item{title}{Char. The title of the plot.}

\item{show_neighbors}{bool. Show the points used for extrapolation if TRUE.}

\item{show_extrapolated_points_and_lines}{bool. Show the extrapolated points
and curves used for extrapolation.}

\item{...}{Parameters that can be used to tune extrapolation, including
\code{spar}, \code{k}, and \code{noise_level}. See \code{\link{extrapolate}}
for explanations.}
}
\value{
ggplot2 graph object. The graph to be shown.
}
\description{
\code{illustrate_extrapolation} plots elements of extrapolations
(e.g., marked points, reference lines) in the same style as
\code{\link{illustrate_signal}}.
}
\examples{
  # Use the maxed-out data for the conceptual diagram
  df = conceptual_diagram_data[
         conceptual_diagram_data['GRANGE'] == 2,
         c("HEADER_TIME_STAMP", "X")]

  # Plot extrapolation illustration using default settings
  illustrate_extrapolation(df, dynamic_range=c(-2,2))

  # Do not show neighbor points
  illustrate_extrapolation(df, dynamic_range=c(-2,2), show_neighbors=FALSE)

  # Do not show extrapolated points and lines
  illustrate_extrapolation(df,
                           dynamic_range=c(-2,2),
                           show_extrapolated_points_and_lines=FALSE)
}
\seealso{
Other visualization functions.: 
\code{\link{generate_interactive_plot}()},
\code{\link{illustrate_signal}()}
}
\concept{visualization functions.}
