% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{topic_model_data}
\alias{topic_model_data}
\title{Topic model dataset}
\format{
A list with 8 components:
\describe{
\item{covars}{Data frame (916 x 11): Control variables}
\item{estimation_data}{Data frame (916 x 672): Contains outcome \code{ly} and word frequencies}
\item{gamma_draws}{Data frame (2000 x 2): MCMC draws}
\item{theta_est_full}{Data frame (916 x 2): Full sample topic proportions}
\item{theta_est_samp}{Data frame (916 x 2): Subsample topic proportions}
\item{beta_est_full}{Data frame (2 x 654): Full sample topic-word distributions}
\item{beta_est_samp}{Data frame (2 x 654): Subsample topic-word distributions}
\item{lda_data}{Data frame (916 x 2): LDA validation data}
}
}
\source{
CEO diary data from Bandiera et al (2020), Journal of Political Economy
}
\usage{
topic_model_data
}
\description{
Dataset containing topic model outputs for demonstrating bias correction
methods in topic model regressions using CEO diary data.
}
\examples{
data(topic_model_data)

# Basic exploration
Y <- topic_model_data$estimation_data$ly
theta <- as.matrix(topic_model_data$theta_est_full)

cat("Sample size:", length(Y), "\n")
cat("Mean log employment:", round(mean(Y), 2), "\n")
cat("Topic 1 mean:", round(mean(theta[, 1]), 3), "\n")

}
\seealso{
\code{\link{ols_bca_topic}}, \code{\link{ols_bcm_topic}}
}
\keyword{datasets}
