% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Regression.R
\name{R2_score}
\alias{R2_score}
\title{R-Squared (Coefficient of Determination) Regression Score}
\usage{
R2_score(y_true, y_pred)
}
\arguments{
\item{y_true}{Ground truth (correct) target values vector}

\item{y_pred}{Estimated target values vector}
}
\value{
R^2 score
}
\description{
Compute the R-Squared (Coefficient of Determination) Regression Score.
}
\examples{
data(cars)
reg <- lm(log(dist)~log(speed), data=cars)
R2_score(y_true=log(cars$dist), y_pred=reg$fitted.values)
}

