% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_utils.R
\name{table_evaluation_results}
\alias{table_evaluation_results}
\title{Evaluation Results}
\usage{
table_evaluation_results(analysis_object, show_table = FALSE)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with 'fine_tuning()'.}

\item{show_table}{Boolean. Whether to print the table.}
}
\value{
Tibble or list of tibbles (multiclass classification) with evaluation results.
}
\description{
The \strong{table_evaluation_results()} function provides access to trained model
evaluation metrics, automatically adapting to the type of problem being analyzed.
For binary classification problems, it returns a unified table with performance
metrics, while for multiclass classification it generates separate tables for
training and test data, enabling comparative performance evaluation and
detection of potential overfitting.
}
\examples{
# Note: For obtaining the evaluation table the user needs to
# complete till fine_tuning( ) function.

# See the full pipeline example under table_best_hyperparameters()
# Final call signature:
# table_evaluation_results(wrap_object)

}
\seealso{
\code{\link{table_best_hyperparameters}}
}
