% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extreme.R
\name{extreme_on_y}
\alias{extreme_on_y}
\title{Extremeness of cases on the dependent variable}
\usage{
extreme_on_y(lmobject)
}
\arguments{
\item{lmobject}{Object generated with \code{\link[stats]{lm}}}
}
\value{
A dataframe with

- all variables in the linear model,

- absolute extremeness (absolute value of difference between variable
score and mean value of variable),

- extremeness (difference between variable score and mean value of
variable), which can be useful when the direction of extremeness is relevant.

The rows are ordered in decreasing order of the absolute extreme values.
}
\description{
Extremeness of a case is calculated by the difference between a case's
value on the dependent variable and the variable's mean value.
}
\details{
Calculating the absolute value of the difference between the cases' values
and the variable's mean value is proposed by Seawright, Jason (2016): The
Case for Selecting Cases That Are Deviant or Extreme on the Independent
Variable. \emph{Sociological Methods & Research} 45 (3): 493-525.
(\url{https://doi.org/10.1177/0049124116643556})
}
\examples{
df <- lm(mpg ~ disp + wt, data = mtcars)
extreme_on_y(df)

}
