% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testCoAccessibility.R
\name{testCoAccessibilityChromVar}
\alias{testCoAccessibilityChromVar}
\title{\code{testCoAccessibilityChromVar}}
\usage{
testCoAccessibilityChromVar(
  SampleTileObj,
  tile1,
  tile2,
  numCores = 1,
  ZI = TRUE,
  backNumber = 1000,
  returnBackGround = FALSE,
  highMem = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{SampleTileObj}{The SummarizedExperiment object output from
getSampleTileMatrix containing your sample-tile matrices}

\item{tile1}{vector of indices or tile names (chrX:100-2000) for tile pairs
to test (first tile in each pair)}

\item{tile2}{vector of indices or tile names (chrX:100-2000) for tile pairs
to test (second tile in each pair)}

\item{numCores}{Optional, the number of cores to use with multiprocessing.
Default is 1.}

\item{ZI}{boolean flag that enables zero-inflated (ZI) Spearman correlations
to be used. Default is TRUE. If FALSE, skip zero-inflation and calculate
the normal Spearman.}

\item{backNumber}{number of ChromVAR-matched background pairs. Default is
1000.}

\item{returnBackGround}{Boolean, if TRUE return the background correlations
as well as foreground. Default is FALSE.}

\item{highMem}{Boolean to control memory usage. Default is FALSE. Only set
highMem to TRUE if you have plenty of memory and want to run this function
faster.s}

\item{verbose}{Set TRUE to display additional messages. Default is FALSE.}
}
\value{
foreGround A data.frame with Tile1, Tile2, Correlation, and p-value
  for that correlation compared to the background
}
\description{
\code{testCoAccessibilityChromVar} takes an input set of tile
  pairs and tests whether they are significantly different compared to a
  background set found via ChromVAR
}
