% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportCoverage.R
\name{exportCoverage}
\alias{exportCoverage}
\title{\code{exportCoverage}}
\usage{
exportCoverage(
  SampleTileObject,
  dir = getwd(),
  type = TRUE,
  cellPopulations = "ALL",
  groupColumn = NULL,
  subGroups = NULL,
  sampleSpecific = FALSE,
  saveFile = TRUE,
  numCores = 1,
  verbose = FALSE
)
}
\arguments{
\item{SampleTileObject}{The SummarizedExperiment object output from
getSampleTileMatrix}

\item{dir}{string. Directory to save files to.}

\item{type}{Boolean. Default is TRUE, and exports Coverage. If set to FALSE,
exports Insertions.}

\item{cellPopulations}{vector of strings. Cell subsets for which to call
peaks. This list of group names must be identical to names that appear in
the SampleTileObject.  Optional, if cellPopulations='ALL', then peak calling
is done on all cell populations. Default is 'ALL'.}

\item{groupColumn}{Optional, the column containing sample group labels for
returning coverage within sample groups. Default is NULL, all samples will
be used.}

\item{subGroups}{a list of subgroup(s) within the groupColumn from the
metadata. Optional, default is NULL, all labels within groupColumn will be
used.}

\item{sampleSpecific}{If TRUE, a BigWig will export for each sample-cell type
combination.}

\item{saveFile}{Boolean. If TRUE, it will save to a BigWig. If FALSE, it will
return the GRangesList without writing a BigWig.}

\item{numCores}{integer. Number of cores to parallelize peak-calling across
multiple cell populations}

\item{verbose}{Set TRUE to display additional messages. Default is FALSE.}
}
\value{
countSE a SummarizedExperiment containing coverage for the given
  input cell populations.
}
\description{
\code{exportCoverage} will export normalized coverage files to
  BigWig files, either as sample-specific or sample-averaged files, for
  visualization in genome browsers.
}
\examples{
\dontrun{
MOCHA::exportCoverage(
  SampleTileObject = SampleTileMatrices,
  cellPopulations = "ALL",
  numCores = 30,
  sampleSpecific = FALSE
)
}

}
